/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import jp.hasc.hasctool.core.messaging.MessageQueue;
import jp.hasc.hasctool.core.runtime.FileStreamProvider;
import jp.hasc.hasctool.core.runtime.TaskManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RuntimeContext {
    private static final Log LOG = LogFactory.getLog(RuntimeContext.class);
    private TaskManager taskManager_;
    private RuntimeContext parentContext_ = null;
    private ArrayList<RuntimeContext> childContexts_ = new ArrayList();
    private int defaultMessageQueueCapacity_ = Integer.MAX_VALUE;
    private ArrayList<MessageQueue> messageQueues_ = new ArrayList();
    private FileStreamProvider fileStreamProvider_;
    private Map<String, Object> repogitory_ = new HashMap<String, Object>();
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private List<Runnable> tasksTerminationListeners_ = Collections.synchronizedList(new ArrayList());
    private boolean stopTasksWhenUnhandledException_ = true;

    private void doInit() {
        this.taskManager_ = new TaskManager(this);
    }

    public RuntimeContext() {
        this.doInit();
    }

    public RuntimeContext(RuntimeContext parentContext) {
        this.parentContext_ = parentContext;
        this.doInit();
    }

    public void addChildContext(RuntimeContext c) {
        this.childContexts_.add(c);
    }

    public void removeChildContext(RuntimeContext c) {
        this.childContexts_.remove(c);
    }

    TaskManager getTaskManager() {
        return this.taskManager_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageQueue createMessageQueue(int capacity) {
        MessageQueue queue = capacity == Integer.MAX_VALUE ? new MessageQueue() : new MessageQueue(capacity);
        ArrayList<MessageQueue> arrayList = this.messageQueues_;
        synchronized (arrayList) {
            this.messageQueues_.add(queue);
        }
        return queue;
    }

    public MessageQueue createDefaultMessageQueue() {
        return this.createMessageQueue(this.defaultMessageQueueCapacity_);
    }

    public void setDefaultMessageQueueCapacity(int queueCapacity) {
        this.defaultMessageQueueCapacity_ = queueCapacity;
    }

    public ArrayList<MessageQueue> getMessageQueues() {
        return this.messageQueues_;
    }

    public FileStreamProvider getFileStreamProvider() {
        return this.fileStreamProvider_;
    }

    public void setFileStreamProvider(FileStreamProvider fileStreamProvider) {
        this.fileStreamProvider_ = fileStreamProvider;
    }

    public void putObjectToRepogitory(String key, Object obj) {
        this.repogitory_.put(key, obj);
    }

    public void putObjectToRepogitory(Class<?> c, Object obj) {
        this.repogitory_.put(c.getName(), obj);
    }

    public Object getObjectFromRepogitory(String key) {
        return this.repogitory_.get(key);
    }

    public Object getObjectFromRepogitory(Class<?> c) {
        return this.repogitory_.get(c.getName());
    }

    public void startTasks() {
        this.taskManager_.startAll();
    }

    public void stopTasks() {
        for (RuntimeContext childContext : this.childContexts_) {
            childContext.getTaskManager().shutdownPhase1();
        }
        this.taskManager_.shutdownPhase1();
        this.taskManager_.shutdownPhase2();
    }

    public boolean awaitTasksTermination() throws InterruptedException {
        return this.awaitTasksTermination(0L);
    }

    public boolean awaitTasksTermination(long timeout) throws InterruptedException {
        return this.taskManager_.awaitTermination(timeout);
    }

    public boolean isTasksRunning() {
        return this.taskManager_.isRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onTasksTerminated() {
        ArrayList<MessageQueue> queues;
        ArrayList<MessageQueue> arrayList = queues = this.getMessageQueues();
        synchronized (arrayList) {
            for (MessageQueue queue : queues) {
                BlockingQueue<Object> bq = queue.getQueueImpl();
                if (bq.isEmpty()) continue;
                bq.clear();
            }
            queues.clear();
        }
        ArrayList<Runnable> listeners = new ArrayList<Runnable>();
        listeners.addAll(this.tasksTerminationListeners_);
        for (Runnable r : listeners) {
            r.run();
        }
    }

    public List<Runnable> tasksTerminationListeners() {
        return this.tasksTerminationListeners_;
    }

    public void addTasksTerminationListener(Runnable r) {
        this.tasksTerminationListeners_.add(r);
    }

    public void removeTasksTerminationListener(Runnable r) {
        this.tasksTerminationListeners_.remove(r);
    }

    public void onCatchUnhandledException(Throwable ex) {
        if (this.taskManager_.isRunning() && this.stopTasksWhenUnhandledException_) {
            LOG.error((Object)("Stopping tasks due to the unhandled exception: " + ex.toString()));
            this.stopTasks();
        }
    }

    public boolean isStopTasksWhenUnhandledException() {
        return this.stopTasksWhenUnhandledException_;
    }

    public void setStopTasksWhenUnhandledException(boolean stopTasksWhenUnhandledException) {
        this.stopTasksWhenUnhandledException_ = stopTasksWhenUnhandledException;
    }

    public RuntimeContext getParentContext() {
        return this.parentContext_;
    }

    public ArrayList<RuntimeContext> getChildContexts() {
        return this.childContexts_;
    }
}

