/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime;

import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import jp.hasc.hasctool.core.data.SignalMessage;
import jp.hasc.hasctool.core.messaging.MessageQueue;
import jp.hasc.hasctool.core.runtime.AbstractTask;
import jp.hasc.hasctool.core.runtime.RuntimeContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class TaskManager {
    private static final Log LOG = LogFactory.getLog(TaskManager.class);
    private RuntimeContext context_;
    private ExecutorService executorService_ = null;
    private ArrayList<AbstractTask> tasksToStart_ = new ArrayList();
    private ConcurrentLinkedQueue<Future<?>> runningTasks_ = new ConcurrentLinkedQueue();
    public static final long SHUTDOWN_TIMEOUT_SECS = 5L;
    private boolean started_ = false;

    public ExecutorService getExecutorService() {
        return this.executorService_;
    }

    public TaskManager(RuntimeContext context) {
        this.context_ = context;
        RuntimeContext parentContext = context.getParentContext();
        this.executorService_ = parentContext != null ? parentContext.getTaskManager().getExecutorService() : Executors.newCachedThreadPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownPhase1() {
        TaskManager taskManager = this;
        synchronized (taskManager) {
            if (!this.started_) {
                return;
            }
        }
        LOG.debug((Object)"shotdown...");
        try {
            ArrayList<MessageQueue> queues;
            ArrayList<MessageQueue> arrayList = queues = this.context_.getMessageQueues();
            synchronized (arrayList) {
                for (MessageQueue queue : queues) {
                    BlockingQueue<Object> bq = queue.getQueueImpl();
                    if (!bq.isEmpty()) {
                        bq.clear();
                    }
                    if (bq.remainingCapacity() <= 0) continue;
                    bq.add((Object)SignalMessage.END);
                }
                queues.clear();
            }
        }
        catch (Throwable ex) {
            LOG.warn((Object)"Throwable", ex);
        }
        if (!this.executorService_.isShutdown()) {
            this.executorService_.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownPhase2() {
        TaskManager taskManager = this;
        synchronized (taskManager) {
            if (!this.started_) {
                return;
            }
        }
        ExecutorService pool = this.executorService_;
        try {
            if (!pool.awaitTermination(5L, TimeUnit.SECONDS)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(5L, TimeUnit.SECONDS)) {
                    LOG.warn((Object)"Pool did not terminate");
                }
            }
        }
        catch (InterruptedException interruptedException) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
        TaskManager taskManager2 = this;
        synchronized (taskManager2) {
            this.started_ = false;
            this.notifyAll();
        }
        LOG.debug((Object)"terminated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(AbstractTask task) {
        TaskManager taskManager = this;
        synchronized (taskManager) {
            if (!this.started_) {
                this.tasksToStart_.add(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(AbstractTask task) {
        TaskManager taskManager = this;
        synchronized (taskManager) {
            if (!this.started_) {
                return;
            }
            this.runningTasks_.add(this.executorService_.submit(task));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAll() {
        LOG.debug((Object)"startAll");
        TaskManager taskManager = this;
        synchronized (taskManager) {
            if (this.started_) {
                throw new IllegalStateException();
            }
            this.started_ = true;
            this.runningTasks_.clear();
            for (AbstractTask task : this.tasksToStart_) {
                Future<Object> f = this.executorService_.submit(task);
                this.runningTasks_.add(f);
            }
            this.tasksToStart_.clear();
        }
        this.executorService_.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    try {
                        while (!TaskManager.this.runningTasks_.isEmpty()) {
                            try {
                                Future f = (Future)TaskManager.this.runningTasks_.poll();
                                if (f == null) continue;
                                f.get();
                            }
                            catch (ExecutionException ex) {
                                LOG.warn((Object)"ExecutionException", (Throwable)ex);
                            }
                        }
                    }
                    catch (InterruptedException ex) {
                        LOG.warn((Object)"InterruptedException", (Throwable)ex);
                        if (!TaskManager.this.executorService_.isShutdown()) {
                            LOG.debug((Object)"done");
                        } else {
                            LOG.debug((Object)"done (shutdowned)");
                        }
                        TaskManager taskManager = TaskManager.this;
                        synchronized (taskManager) {
                            TaskManager.this.started_ = false;
                            TaskManager.this.notifyAll();
                        }
                        TaskManager.this.context_.onTasksTerminated();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    if (!TaskManager.this.executorService_.isShutdown()) {
                        LOG.debug((Object)"done");
                    } else {
                        LOG.debug((Object)"done (shutdowned)");
                    }
                    TaskManager taskManager = TaskManager.this;
                    synchronized (taskManager) {
                        TaskManager.this.started_ = false;
                        TaskManager.this.notifyAll();
                    }
                    TaskManager.this.context_.onTasksTerminated();
                    throw throwable;
                }
                if (!TaskManager.this.executorService_.isShutdown()) {
                    LOG.debug((Object)"done");
                } else {
                    LOG.debug((Object)"done (shutdowned)");
                }
                TaskManager taskManager = TaskManager.this;
                synchronized (taskManager) {
                    TaskManager.this.started_ = false;
                    TaskManager.this.notifyAll();
                }
                TaskManager.this.context_.onTasksTerminated();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean awaitTermination(long timeout) throws InterruptedException {
        TaskManager taskManager = this;
        synchronized (taskManager) {
            long endAt;
            long l = endAt = timeout > 0L ? System.currentTimeMillis() + timeout : 0L;
            while (true) {
                if (!this.started_) {
                    return true;
                }
                if (timeout > 0L) {
                    long dt = endAt - System.currentTimeMillis();
                    if (dt <= 0L) {
                        return false;
                    }
                    this.wait(dt);
                    continue;
                }
                this.wait();
            }
        }
    }

    public boolean isRunning() {
        return this.started_;
    }

    public void runDirect(AbstractTask task) throws InterruptedException {
        this.tasksToStart_.remove(task);
        task.run();
    }
}

