/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime.filter;

import jp.hasc.hasctool.core.data.ScalarSignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessages;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;

public abstract class AbstractScalarFilter
extends AbstractFilter {
    @Override
    public void processMessage(Object message) throws InterruptedException {
        if (message instanceof ScalarSignalMessage) {
            ScalarSignalMessage se = (ScalarSignalMessage)message;
            double newVal = this.filterScalarValue(se.getScalarValue());
            this.outputMessage(new ScalarSignalMessage(se.getTime(), newVal));
        } else if (message instanceof VectorSignalMessage) {
            VectorSignalMessage ve = (VectorSignalMessage)message;
            double[] newVal = new double[ve.getVectorSize()];
            int i = 0;
            while (i < ve.getVectorSize()) {
                newVal[i] = this.filterScalarValue(ve.getVectorElement(i));
                ++i;
            }
            this.outputMessage(VectorSignalMessages.create(ve.getTime(), newVal, false));
        } else {
            this.outputMessage(message);
        }
    }

    public abstract double filterScalarValue(double var1);
}

