/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime.filter;

import jp.hasc.hasctool.core.data.VectorSignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessages;
import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;

public class IIRFilter
extends AbstractFilter {
    private double[] preElement_;
    private double coefficient_;

    @Override
    public void setup(RuntimeContext context) {
        super.setup(context);
        this.preElement_ = new double[1];
    }

    public void setCoefficient(double val) {
        this.coefficient_ = val;
        if (this.coefficient_ < 0.0) {
            this.coefficient_ = 0.0;
        } else if (this.coefficient_ > 1.0) {
            this.coefficient_ = 1.0;
        }
        this.preElement_ = new double[1];
    }

    private void createData(double[] valAry, int index) {
        this.preElement_ = new double[index];
        if (index > valAry.length) {
            int i = 0;
            while (i < valAry.length) {
                this.preElement_[i] = valAry[i];
                ++i;
            }
        } else {
            int i = 0;
            while (i < index) {
                this.preElement_[i] = valAry[i];
                ++i;
            }
        }
    }

    private void setData(double val, int index) {
        this.preElement_[index] = val;
    }

    @Override
    public void processMessage(Object message) throws InterruptedException {
        if (message instanceof VectorSignalMessage) {
            VectorSignalMessage vsig = (VectorSignalMessage)message;
            double[] newValue = new double[vsig.getVectorSize()];
            if (vsig.getVectorSize() != this.preElement_.length) {
                this.createData(this.preElement_, vsig.getVectorSize());
            }
            int i = 0;
            while (i < newValue.length) {
                newValue[i] = this.coefficient_ * vsig.getVectorElement(i) + (1.0 - this.coefficient_) * this.preElement_[i];
                this.setData(newValue[i], i);
                ++i;
            }
            this.outputMessage(VectorSignalMessages.create(vsig.getTime(), newValue));
        } else {
            this.outputMessage(message);
        }
    }
}

