/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime.filter;

import jp.hasc.hasctool.core.data.VectorSignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessages;
import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;

public class MeanFilter
extends AbstractFilter {
    private long[] time_;
    private double[][] sampleData_;
    private int length_;
    private int next_;
    private boolean fill_;

    @Override
    public void setup(RuntimeContext context) {
        super.setup(context);
        this.time_ = new long[this.length_];
        this.sampleData_ = new double[1][this.length_];
        this.next_ = 0;
        this.fill_ = false;
    }

    public void setSampleNum(int samplenum) {
        this.length_ = samplenum;
    }

    private void createData(double[][] valAry, int index) {
        this.sampleData_ = new double[index][this.length_];
        if (index > valAry.length) {
            int i = 0;
            while (i < valAry.length) {
                int j = 0;
                while (j < this.length_) {
                    this.sampleData_[i][j] = valAry[i][j];
                    ++j;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < index) {
                int j = 0;
                while (j < this.length_) {
                    this.sampleData_[i][j] = valAry[i][j];
                    ++j;
                }
                ++i;
            }
        }
    }

    private void setTime(long time) {
        this.time_[this.next_] = time;
    }

    private void setData(double val, int index) {
        this.sampleData_[index][this.next_] = val;
    }

    private double mean(int index) {
        double sum = 0.0;
        int j = 0;
        while (j < this.length_) {
            sum += this.sampleData_[index][j];
            ++j;
        }
        double newValue = sum / (double)this.length_;
        return newValue;
    }

    @Override
    public void processMessage(Object message) throws InterruptedException {
        if (message instanceof VectorSignalMessage) {
            VectorSignalMessage vsig = (VectorSignalMessage)message;
            if (vsig.getVectorSize() != this.sampleData_.length) {
                this.createData(this.sampleData_, vsig.getVectorSize());
            }
            int len = this.sampleData_.length;
            int i = 0;
            while (i < len) {
                this.setTime(vsig.getTime());
                this.setData(vsig.getVectorElement(i), i);
                ++i;
            }
            this.next_ = (this.next_ + 1) % this.length_;
            if (this.next_ == 0 && !this.fill_) {
                this.fill_ = true;
            }
            if (this.fill_) {
                long stime = this.time_[this.next_];
                double[] newValue = new double[len];
                int i2 = 0;
                while (i2 < len) {
                    newValue[i2] = this.mean(i2);
                    ++i2;
                }
                this.outputMessage(VectorSignalMessages.create(stime, newValue));
            }
        } else {
            this.outputMessage(message);
        }
    }
}

