/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime.filter;

import java.util.concurrent.TimeUnit;
import jp.hasc.hasctool.core.data.SignalMessage;
import jp.hasc.hasctool.core.messaging.MessageConnector;
import jp.hasc.hasctool.core.messaging.MessageProcessor;
import jp.hasc.hasctool.core.messaging.MessageQueue;
import jp.hasc.hasctool.core.runtime.AbstractTask;
import jp.hasc.hasctool.core.runtime.RuntimeContext;

public class SleepFilter
extends AbstractTask {
    private MessageQueue inputPort_;
    private MessageConnector outputPort_ = new MessageConnector();
    private double timeScale_ = 1.0;

    @Override
    public void setup(RuntimeContext context) {
        super.setup(context);
        this.inputPort_ = this.getRuntimeContext().createDefaultMessageQueue();
    }

    public MessageProcessor getInputPort() {
        return this.inputPort_;
    }

    public MessageConnector getOutputPort() {
        return this.outputPort_;
    }

    protected void outputMessage(Object message) throws InterruptedException {
        this.getOutputPort().processMessage(message);
    }

    public double getTimeScale() {
        return this.timeScale_;
    }

    public void setTimeScale(double timeScale) {
        this.timeScale_ = timeScale;
    }

    @Override
    protected void run() throws InterruptedException {
        boolean first = true;
        boolean ended = false;
        long sigStart = 0L;
        long hwStart = 0L;
        while (!this.isShutdown() && !ended) {
            Object obj = this.inputPort_.readMessage();
            if (obj instanceof SignalMessage) {
                SignalMessage sig = (SignalMessage)obj;
                long now = System.currentTimeMillis();
                if (first) {
                    first = false;
                    sigStart = sig.getTime();
                    hwStart = now;
                } else {
                    long hwT;
                    long sigT = (long)((double)(sig.getTime() - sigStart) * this.timeScale_);
                    long dt = sigT - (hwT = SignalMessage.TIME_UNIT.convert(now - hwStart, TimeUnit.MILLISECONDS));
                    if (dt > 0L) {
                        Thread.sleep(TimeUnit.MILLISECONDS.convert(dt, SignalMessage.TIME_UNIT));
                    }
                }
            } else if (obj == SignalMessage.END) {
                ended = true;
            }
            this.outputMessage(obj);
        }
    }
}

