/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime.filter;

import jp.hasc.hasctool.core.data.SignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessages;
import jp.hasc.hasctool.core.runtime.filter.interpolator.AbstractMultipleInputsFilter;
import jp.hasc.hasctool.core.runtime.filter.interpolator.LinearVectorInterporator;
import jp.hasc.hasctool.core.runtime.filter.interpolator.SignalInterpolator;

public class VectorAdder
extends AbstractMultipleInputsFilter {
    @Override
    public SignalInterpolator createSignalInterpolator(int portIndex) {
        return new LinearVectorInterporator();
    }

    @Override
    protected boolean acceptSignalMessage(int portIndex, SignalMessage signalMessage) {
        return signalMessage instanceof VectorSignalMessage;
    }

    @Override
    protected void processSignalMessages(long time, SignalMessage[] messages) throws InterruptedException {
        int pi = this.getPrimaryInputPortIndex();
        VectorSignalMessage pvse = (VectorSignalMessage)messages[pi];
        int valSize = pvse.getVectorSize();
        double[] val = new double[valSize];
        int j = 0;
        while (j < valSize) {
            val[j] = 0.0;
            ++j;
        }
        int i = 0;
        while (i < messages.length) {
            VectorSignalMessage vse = (VectorSignalMessage)messages[i];
            int j2 = 0;
            while (j2 < valSize) {
                int n = j2;
                val[n] = val[n] + vse.getVectorElement(j2);
                ++j2;
            }
            ++i;
        }
        this.outputMessage(VectorSignalMessages.create(time, val, false));
    }
}

