/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime.filter;

import jp.hasc.hasctool.core.data.VectorSignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessages;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;

public class VectorAngleFilter
extends AbstractFilter {
    @Override
    public void processMessage(Object message) throws InterruptedException {
        if (message instanceof VectorSignalMessage) {
            VectorSignalMessage vsig = (VectorSignalMessage)message;
            double[] newValue = new double[vsig.getVectorSize()];
            int i = 0;
            while (i < newValue.length) {
                int index = (i + 1) % newValue.length;
                double val = 0.0;
                if (vsig.getVectorElement(index) != 0.0) {
                    val = vsig.getVectorElement(i) / vsig.getVectorElement(index);
                }
                newValue[i] = Math.atan(val);
                ++i;
            }
            this.outputMessage(VectorSignalMessages.create(vsig.getTime(), newValue));
        } else {
            this.outputMessage(message);
        }
    }
}

