/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime.filter;

import jp.hasc.hasctool.core.data.SignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessages;
import jp.hasc.hasctool.core.runtime.filter.interpolator.AbstractMultipleInputsFilter;
import jp.hasc.hasctool.core.runtime.filter.interpolator.LinearVectorInterporator;
import jp.hasc.hasctool.core.runtime.filter.interpolator.SignalInterpolator;

public class VectorConcatenater
extends AbstractMultipleInputsFilter {
    @Override
    public SignalInterpolator createSignalInterpolator(int portIndex) {
        return new LinearVectorInterporator();
    }

    @Override
    protected boolean acceptSignalMessage(int portIndex, SignalMessage signalMessage) {
        return signalMessage instanceof VectorSignalMessage;
    }

    @Override
    protected void processSignalMessages(long time, SignalMessage[] messages) throws InterruptedException {
        int valsize = 0;
        int i = 0;
        while (i < messages.length) {
            valsize += ((VectorSignalMessage)messages[i]).getVectorSize();
            ++i;
        }
        double[] val = new double[valsize];
        int vi = 0;
        int i2 = 0;
        while (i2 < messages.length) {
            VectorSignalMessage vse = (VectorSignalMessage)messages[i2];
            int j = 0;
            while (j < vse.getVectorSize()) {
                val[vi++] = vse.getVectorElement(j);
                ++j;
            }
            ++i2;
        }
        this.outputMessage(VectorSignalMessages.create(time, val, false));
    }
}

