/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime.filter;

import jp.hasc.hasctool.core.data.VectorSignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessages;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;

public class VectorElementsFilter
extends AbstractFilter {
    private int startIndex_;
    private int endIndex_;

    @Override
    public void processMessage(Object message) throws InterruptedException {
        if (message instanceof VectorSignalMessage) {
            VectorSignalMessage vsig = (VectorSignalMessage)message;
            int len = this.endIndex_ - this.startIndex_ + 1;
            double[] newValue = new double[len];
            int index = this.startIndex_;
            int i = 0;
            while (i < len) {
                newValue[i] = vsig.getVectorElement(index + i);
                ++i;
            }
            this.outputMessage(VectorSignalMessages.create(vsig.getTime(), newValue));
        } else {
            this.outputMessage(message);
        }
    }

    public void setStartIndex(int startIndex) {
        this.startIndex_ = startIndex;
    }

    public void setEndIndex(int endIndex) {
        this.endIndex_ = endIndex;
    }
}

