/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime.filter;

import java.util.concurrent.TimeUnit;
import jp.hasc.hasctool.core.data.SignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessages;
import jp.hasc.hasctool.core.messaging.MessageConnector;
import jp.hasc.hasctool.core.messaging.MessageProcessor;
import jp.hasc.hasctool.core.messaging.MessageQueue;
import jp.hasc.hasctool.core.runtime.AbstractTask;
import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.filter.interpolator.PeriodicSignalSampler;
import jp.hasc.hasctool.core.runtime.filter.interpolator.VectorPeriodicSignalSampler;

public class VectorIntegrator
extends AbstractTask {
    private VectorSignalMessage initialValue_;
    private long timeStep_;
    private long unitTime_ = SignalMessage.TIME_UNIT.convert(1L, TimeUnit.SECONDS);
    private PeriodicSignalSampler inputSampler_;
    private MessageQueue inputQueue_;
    private MessageConnector outputPort_ = new MessageConnector();

    public MessageProcessor getInputPort() {
        return this.inputSampler_;
    }

    public MessageConnector getOutputPort() {
        return this.outputPort_;
    }

    protected void outputMessage(Object message) throws InterruptedException {
        this.getOutputPort().processMessage(message);
    }

    @Override
    public void setup(RuntimeContext context) {
        super.setup(context);
        this.inputQueue_ = this.getRuntimeContext().createDefaultMessageQueue();
        this.inputSampler_ = new VectorPeriodicSignalSampler();
        this.inputSampler_.setTimeStep(this.timeStep_);
        this.inputSampler_.setInitialTime(this.initialValue_.getTime());
        this.inputSampler_.setup(context);
        this.inputSampler_.getOutputPort().connect(this.inputQueue_);
    }

    @Override
    protected void run() throws InterruptedException {
        this.outputMessage((Object)SignalMessage.BEGIN);
        this.outputMessage(this.initialValue_);
        long time = this.initialValue_.getTime();
        double[] sumValue = new double[this.initialValue_.getVectorSize()];
        int i = 0;
        while (i < sumValue.length) {
            sumValue[i] = this.initialValue_.getVectorElement(i);
            ++i;
        }
        double dt = (double)this.timeStep_ / (double)this.unitTime_;
        while (!this.isShutdown()) {
            Object message = this.inputQueue_.readMessage();
            if (message instanceof VectorSignalMessage) {
                VectorSignalMessage vec = (VectorSignalMessage)message;
                if (time != vec.getTime()) {
                    throw new RuntimeException();
                }
                time += this.timeStep_;
                int i2 = 0;
                while (i2 < sumValue.length) {
                    int n = i2;
                    sumValue[n] = sumValue[n] + vec.getVectorElement(i2) * dt;
                    ++i2;
                }
                this.outputMessage(VectorSignalMessages.create(time, sumValue, true));
                continue;
            }
            if (message == SignalMessage.END) break;
        }
        this.outputMessage((Object)SignalMessage.END);
    }

    public long getUnitTime() {
        return this.unitTime_;
    }

    public void setUnitTime(long unitTime) {
        this.unitTime_ = unitTime;
    }

    public VectorSignalMessage getInitialValue() {
        return this.initialValue_;
    }

    public void setInitialValue(VectorSignalMessage initialValue) {
        this.initialValue_ = initialValue;
    }

    public long getTimeStep() {
        return this.timeStep_;
    }

    public void setTimeStep(long timeStep) {
        this.timeStep_ = timeStep;
    }
}

