/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime.filter.evaluation;

public class EvaluationData {
    String[] element_;
    double[][] data_;

    public EvaluationData(String element) {
        this.setup(element.split(","));
    }

    void setup(String[] elementArray) {
        int len = elementArray.length;
        this.data_ = new double[len][len];
        this.element_ = new String[len];
        int i = 0;
        while (i < len) {
            this.element_[i] = elementArray[i];
            ++i;
        }
    }

    public void setData(double val, int x, int y) {
        double[] dArray = this.data_[x];
        int n = y;
        dArray[n] = dArray[n] + val;
    }

    public int getElementNum() {
        return this.element_.length;
    }

    public String getElement(int index) {
        return this.element_[index];
    }

    public String[][] getData() {
        return this.createTable();
    }

    public void div(double time, int index) {
        int len = this.data_[0].length;
        int i = 0;
        while (i < len) {
            int j = 0;
            while (j < len) {
                if (i == index) {
                    double[] dArray = this.data_[i];
                    int n = j;
                    dArray[n] = dArray[n] / time;
                }
                ++j;
            }
            ++i;
        }
    }

    public double getOverAll() {
        double sum = 0.0;
        int len = this.data_[0].length;
        int i = 0;
        while (i < len) {
            int j = 0;
            while (j < len) {
                if (i == j) {
                    sum += this.data_[i][j];
                }
                ++j;
            }
            ++i;
        }
        double overAll = sum /= (double)len;
        return overAll;
    }

    String[][] createTable() {
        int len = this.element_.length;
        String[][] evalTable = new String[len + 1][len + 1];
        evalTable[0][0] = "%";
        int i = 0;
        while (i < len) {
            evalTable[0][i + 1] = this.element_[i];
            evalTable[i + 1][0] = this.element_[i];
            ++i;
        }
        i = 0;
        while (i < len) {
            int j = 0;
            while (j < len) {
                evalTable[i + 1][j + 1] = Double.toString(this.data_[i][j]);
                ++j;
            }
            ++i;
        }
        return evalTable;
    }
}

