/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime.filter.evaluation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import jp.hasc.hasctool.core.data.EnumCommand;
import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;
import jp.hasc.hasctool.core.runtime.filter.evaluation.EvaluationData;
import jp.hasc.hasctool.core.util.CSVUtil;
import jp.hasc.hasctool.core.util.CoreUtil;

public class EvaluationFilter
extends AbstractFilter {
    String element_;
    EvaluationData evalData_;
    String labelFilePath_;
    ArrayList<MyData> correctDList_;
    ArrayList<MyData> preDList_;
    double[] sumT;

    public void setLabelFilePath(String path) {
        this.labelFilePath_ = path;
    }

    public void setLabelPathFromCSVFilePath(String path) {
        this.labelFilePath_ = path.replaceAll("\\.csv$", ".label");
    }

    public void setElement(String element) {
        this.element_ = element;
    }

    @Override
    public void setup(RuntimeContext context) {
        super.setup(context);
        this.start();
    }

    private void start() {
        String[] elementList = this.element_.split(",");
        this.sumT = new double[elementList.length];
        this.correctDList_ = new ArrayList();
        this.preDList_ = new ArrayList();
    }

    private void setData(String[] input, ArrayList<MyData> mdList) {
        int len = input.length;
        if (len == 3) {
            MyData md = new MyData();
            md.setTime(Double.parseDouble(input[0]), Double.parseDouble(input[1]));
            md.setLabel(input[2]);
            mdList.add(md);
        }
    }

    private void evaluate() {
        int len = this.evalData_.getElementNum();
        int i = 0;
        while (i < len) {
            String metaLabel = this.evalData_.getElement(i);
            double[] partT = new double[this.element_.split(",").length];
            int j = 0;
            while (j < len) {
                String evalLabel = this.evalData_.getElement(j);
                partT[j] = this.getTimeLength(metaLabel, evalLabel);
                int n = i;
                this.sumT[n] = this.sumT[n] + partT[j];
                ++j;
            }
            int k = 0;
            while (k < len) {
                double percent = 0.0;
                if (this.sumT[i] != 0.0) {
                    percent = partT[k] / this.sumT[i] * 100.0;
                }
                this.evalData_.setData(percent, i, k);
                ++k;
            }
            ++i;
        }
    }

    private double getTimeLength(String metaLab, String evalLab) {
        int len1 = this.correctDList_.size();
        int len2 = this.preDList_.size();
        double tlength = 0.0;
        int m = 0;
        while (m < len1) {
            double ms = this.correctDList_.get(m).getStartTime(metaLab);
            double me = this.correctDList_.get(m).getEndTime(metaLab);
            if (ms != -1.0 && me != -1.0) {
                int n = 0;
                while (n < len2) {
                    double ns = this.preDList_.get(n).getStartTime(evalLab);
                    double ne = this.preDList_.get(n).getEndTime(evalLab);
                    if (ns != -1.0 && ne != -1.0) {
                        if (ns <= ms) {
                            if (ne >= ms) {
                                tlength = ne <= me ? (tlength += ne - ms) : (tlength += me - ms);
                            }
                        } else if (ns <= me) {
                            tlength = ne >= me ? (tlength += me - ns) : (tlength += ne - ns);
                        }
                    }
                    ++n;
                }
            }
            ++m;
        }
        return tlength;
    }

    @Override
    public void processMessage(Object message) throws InterruptedException {
        if (message instanceof String) {
            String line = (String)message;
            String[] columns = CSVUtil.parseCSVRecord(line);
            this.setData(columns, this.preDList_);
        } else if (message == EnumCommand.BEGIN) {
            try {
                try {
                    String line;
                    InputStream inps = this.getRuntimeContext().getFileStreamProvider().openInputStream(this.labelFilePath_);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inps, RuntimeContext.DEFAULT_CHARSET));
                    while ((line = bufferedReader.readLine()) != null) {
                        String[] columns = CSVUtil.parseCSVRecord(line);
                        this.setData(columns, this.correctDList_);
                    }
                    bufferedReader.close();
                    inps.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (RuntimeException ex) {
                CoreUtil.throwAsRuntimeException(ex);
            }
        } else if (message == EnumCommand.END) {
            this.evalData_ = new EvaluationData(this.element_);
            this.evaluate();
            String[][] evalTable = this.evalData_.getData();
            int len = evalTable[0].length;
            this.outputMessage((Object)EnumCommand.BEGIN);
            int i = 0;
            while (i < len - 1) {
                String metaLabel = this.evalData_.getElement(i);
                this.outputMessage(String.valueOf(metaLabel) + "," + this.sumT[i]);
                ++i;
            }
            i = 0;
            while (i < len) {
                String row = evalTable[i][0];
                int j = 1;
                while (j < len) {
                    row = String.valueOf(row) + "," + evalTable[i][j];
                    ++j;
                }
                this.outputMessage(row);
                ++i;
            }
            this.outputMessage("Overall," + this.evalData_.getOverAll());
            this.outputMessage((Object)EnumCommand.END);
        }
    }

    class MyData {
        double startTime_;
        double endTime_;
        String label_;

        public void setTime(double t1, double t2) {
            this.startTime_ = t1;
            this.endTime_ = t2;
        }

        public void setLabel(String label) {
            this.label_ = label;
        }

        public double getStartTime(String label) {
            if (this.label_.equals(label)) {
                return this.startTime_;
            }
            return -1.0;
        }

        public double getEndTime(String label) {
            if (this.label_.equals(label)) {
                return this.endTime_;
            }
            return -1.0;
        }
    }
}

