/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime.filter.evaluation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import jp.hasc.hasctool.core.data.EnumCommand;
import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;
import jp.hasc.hasctool.core.runtime.filter.evaluation.EvaluationData;
import jp.hasc.hasctool.core.util.CoreUtil;

public class EvaluationMerger
extends AbstractFilter {
    String element_;
    String[] eList_;
    int eleNum_;
    EvaluationData evalData_;
    HashMap<String, Double> hmap_;
    HashMap<String, Double> allmap_;

    public void setElement(String element) {
        this.element_ = element;
    }

    @Override
    public void setup(RuntimeContext context) {
        super.setup(context);
        this.start();
    }

    private void start() {
        this.hmap_ = new HashMap();
        this.allmap_ = new HashMap();
        this.evalData_ = new EvaluationData(this.element_);
        this.eList_ = this.element_.split(",");
        this.eleNum_ = this.eList_.length;
        int i = 0;
        while (i < this.eleNum_) {
            this.allmap_.put(this.eList_[i], 0.0);
            ++i;
        }
    }

    @Override
    public void processMessage(Object message) throws InterruptedException {
        if (message instanceof String) {
            String filePath = (String)message;
            int count = 0;
            boolean start = true;
            try {
                String line;
                InputStream inps = this.getRuntimeContext().getFileStreamProvider().openInputStream(filePath);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inps, RuntimeContext.DEFAULT_CHARSET));
                int i = 0;
                while (i < this.eleNum_) {
                    String line2 = bufferedReader.readLine();
                    String[] row = line2.split(",");
                    this.hmap_.put(row[0], Double.parseDouble(row[1]));
                    ++i;
                }
                while ((line = bufferedReader.readLine()) != null) {
                    if (start) {
                        start = false;
                        continue;
                    }
                    String[] row = line.split(",");
                    int len = row.length;
                    if (len - 1 != this.evalData_.getElementNum()) continue;
                    double time = this.hmap_.get(row[0]);
                    int i2 = 1;
                    while (i2 < len) {
                        int index = i2 - 1;
                        this.evalData_.setData(Double.parseDouble(row[i2]) * time, count, index);
                        ++i2;
                    }
                    ++count;
                }
                i = 0;
                while (i < this.eleNum_) {
                    double alltime = this.allmap_.get(this.eList_[i]);
                    this.allmap_.put(this.eList_[i], alltime += this.hmap_.get(this.eList_[i]).doubleValue());
                    ++i;
                }
                bufferedReader.close();
                inps.close();
            }
            catch (IOException ex) {
                CoreUtil.throwAsRuntimeException(ex);
            }
            catch (RuntimeException runtimeException) {}
        } else if (message == EnumCommand.END) {
            int i = 0;
            while (i < this.eleNum_) {
                double alltime = this.allmap_.get(this.eList_[i]);
                this.evalData_.div(alltime, i);
                ++i;
            }
            String[][] evalTable = this.evalData_.getData();
            int len = evalTable[0].length;
            this.outputMessage((Object)EnumCommand.BEGIN);
            int i3 = 0;
            while (i3 < len) {
                String row = evalTable[i3][0];
                int j = 1;
                while (j < len) {
                    row = String.valueOf(row) + "," + evalTable[i3][j];
                    ++j;
                }
                this.outputMessage(row);
                ++i3;
            }
            this.outputMessage("Overall," + this.evalData_.getOverAll());
            this.outputMessage((Object)EnumCommand.END);
        } else {
            this.outputMessage(message);
        }
    }
}

