/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime.filter.file;

import java.util.concurrent.TimeUnit;
import jp.hasc.hasctool.core.data.SignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessages;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;
import jp.hasc.hasctool.core.util.CSVUtil;

public class CSVToVectorFilter
extends AbstractFilter {
    private int timeColumnIndex_ = 0;
    private double timeUnitSeconds_ = 1.0;

    protected void processRow(String row) throws InterruptedException {
        if (row.startsWith("#")) {
            this.outputMessage(row);
        } else if (!row.isEmpty()) {
            String[] columns = CSVUtil.parseCSVRecord(row);
            double[] vec = new double[columns.length - 1];
            int tci = (this.timeColumnIndex_ + columns.length) % columns.length;
            double dtime = 0.0;
            int i = 0;
            while (i < columns.length) {
                double val = this.getColumnAsDouble(columns[i]);
                if (i < tci) {
                    vec[i] = val;
                } else if (i == tci) {
                    dtime = val;
                } else {
                    vec[i - 1] = val;
                }
                ++i;
            }
            long ltime = SignalMessage.TIME_UNIT.convert((long)(dtime * this.timeUnitSeconds_ * 1000000.0), TimeUnit.MICROSECONDS);
            this.outputMessage(VectorSignalMessages.create(ltime, vec, false));
        }
    }

    protected double getColumnAsDouble(String column) {
        if ((column = column.trim()).startsWith("\"") && column.endsWith("\"")) {
            column = column.substring(1, column.length() - 1);
        }
        return Double.parseDouble(column);
    }

    public int getTimeColumnIndex() {
        return this.timeColumnIndex_;
    }

    public void setTimeColumnIndex(int timeColumnIndex) {
        this.timeColumnIndex_ = timeColumnIndex;
    }

    public double getTimeUnitSeconds() {
        return this.timeUnitSeconds_;
    }

    public void setTimeUnitSeconds(double timeUnitSeconds) {
        this.timeUnitSeconds_ = timeUnitSeconds;
    }

    @Override
    public void processMessage(Object message) throws InterruptedException {
        if (message instanceof String) {
            this.processRow((String)message);
        } else {
            this.outputMessage(message);
        }
    }
}

