/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime.filter.file;

import jp.hasc.hasctool.core.messaging.MessageConnector;
import jp.hasc.hasctool.core.messaging.MessageProcessor;
import jp.hasc.hasctool.core.runtime.AbstractRuntimeBean;
import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.filter.file.CSVToVectorFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HascLogAccToVectorFilter
extends AbstractRuntimeBean
implements MessageProcessor {
    private static final Log LOG = LogFactory.getLog(HascLogAccToVectorFilter.class);
    private int logVersion_ = 0;
    private CSVToVectorFilter csvFilter_ = new CSVToVectorFilter();

    public MessageProcessor getInputPort() {
        return this;
    }

    public MessageConnector getOutputPort() {
        return this.csvFilter_.getOutputPort();
    }

    @Override
    public void setup(RuntimeContext context) {
        super.setup(context);
        this.csvFilter_.setup(context);
    }

    private void outputMessage(Object message) throws InterruptedException {
        this.csvFilter_.processMessage(message);
    }

    @Override
    public void processMessage(Object message) throws InterruptedException {
        if (message instanceof String) {
            String line = (String)message;
            String[] clms = line.split("\t");
            String rowtype = clms[1];
            if (rowtype.equals("ACC")) {
                this.outputMessage(clms[2]);
            } else if (rowtype.equals("TAGS")) {
                if (this.logVersion_ == 0) {
                    this.logVersion_ = 1;
                    this.csvFilter_.setTimeColumnIndex(-1);
                    LOG.debug((Object)("HascLogVer:" + this.logVersion_));
                }
            } else if (rowtype.equals("LOG_VERSION")) {
                this.logVersion_ = Integer.parseInt(clms[2]);
                LOG.debug((Object)("HascLogVer:" + this.logVersion_));
            }
        } else {
            this.outputMessage(message);
        }
    }
}

