/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime.filter.file;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.filter.file.CSVToVectorFilter;
import jp.hasc.hasctool.core.runtime.filter.file.VectorToCSVFilter;
import jp.hasc.hasctool.core.runtime.sink.LineWriterSink;
import jp.hasc.hasctool.core.runtime.source.LineReaderSource;

public class UpdateCSVFileTool {
    public static void main(String[] args) throws Exception {
        UpdateCSVFileTool tool = new UpdateCSVFileTool();
        ArrayList<String> filenames = new ArrayList<String>();
        int i = 0;
        while (i < args.length) {
            filenames.add(args[i]);
            ++i;
        }
        for (String filename : filenames) {
            tool.processFile(filename);
        }
        System.exit(0);
    }

    public void processFile(String filename) throws Exception {
        File file = new File(filename);
        File workfile = new File(String.valueOf(filename) + ".$temp");
        File backupfile = new File(String.valueOf(filename) + ".old");
        System.out.println("converting " + filename);
        if (backupfile.isFile()) {
            System.out.println("Error: " + backupfile + " already exists.");
            return;
        }
        RuntimeContext ctx = new RuntimeContext();
        LineReaderSource lr = new LineReaderSource();
        lr.setReader(new FileReader(file));
        lr.setup(ctx);
        CSVToVectorFilter csvr = new CSVToVectorFilter();
        csvr.setTimeColumnIndex(-1);
        csvr.setup(ctx);
        VectorToCSVFilter csvw = new VectorToCSVFilter();
        csvw.setup(ctx);
        LineWriterSink lw = new LineWriterSink();
        lw.setWriter(new FileWriter(workfile));
        lw.setup(ctx);
        lr.getOutputPort().connect(csvr.getInputPort());
        csvr.getOutputPort().connect(csvw.getInputPort());
        csvw.getOutputPort().connect(lw.getInputPort());
        ctx.startTasks();
        ctx.awaitTasksTermination();
        System.out.println("done.");
        if (!file.renameTo(backupfile)) {
            throw new IOException("can't rename to " + backupfile);
        }
        if (!workfile.renameTo(file)) {
            throw new IOException("can't rename to " + file);
        }
    }
}

