/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime.filter.file;

import jp.hasc.hasctool.core.data.SignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessage;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;

public class VectorToCSVFilter
extends AbstractFilter {
    @Override
    public void processMessage(Object message) throws InterruptedException {
        if (message instanceof VectorSignalMessage) {
            VectorSignalMessage sig = (VectorSignalMessage)message;
            StringBuilder sb = new StringBuilder();
            sb.append((double)SignalMessage.TIME_UNIT.toMicros(sig.getTime()) / 1000000.0);
            int i = 0;
            int num = sig.getVectorSize();
            while (i < num) {
                sb.append(",");
                sb.append(sig.getVectorElement(i));
                ++i;
            }
            this.outputMessage(sb.toString());
        } else if (!(message instanceof SignalMessage)) {
            this.outputMessage(message);
        }
    }
}

