/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime.filter.file.count;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import jp.hasc.hasctool.core.data.EnumCommand;
import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;
import jp.hasc.hasctool.core.util.CoreUtil;

public class MetaFileCounter
extends AbstractFilter {
    private String metaElement_;
    private HashMap<String, Integer> hmap_;
    private String mergeInf_;
    private String key_ = null;
    private ArrayList<String> mergeList_;

    @Override
    public void setup(RuntimeContext context) {
        super.setup(context);
        this.hmap_ = new HashMap();
    }

    @Override
    public void processMessage(Object message) throws InterruptedException {
        if (message instanceof String) {
            String s = (String)message;
            this.count(s);
        } else if (message == EnumCommand.END) {
            for (String key : this.hmap_.keySet()) {
                int count = this.hmap_.get(key);
                String row = String.valueOf(key) + "," + count;
                this.outputMessage(row);
            }
            System.out.println("countEnd");
            this.outputMessage((Object)EnumCommand.END);
        } else {
            this.outputMessage(message);
        }
    }

    private void count(String filePath) {
        try {
            String line;
            InputStream inps = this.getRuntimeContext().getFileStreamProvider().openInputStream(filePath);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inps, RuntimeContext.DEFAULT_CHARSET));
            while ((line = bufferedReader.readLine()) != null) {
                if (line.indexOf(this.metaElement_) < 0) continue;
                String[] row = line.split(":");
                String key = row[row.length - 1];
                key = key.trim();
                if (this.mergeInf_ != null) {
                    key = this.merge(key);
                }
                if (!key.equals(this.key_)) {
                    System.out.println(key);
                    this.key_ = key;
                }
                if (this.hmap_.containsKey(key)) {
                    int count = this.hmap_.get(key);
                    this.hmap_.put(key, ++count);
                    break;
                }
                this.hmap_.put(key, 1);
                break;
            }
            bufferedReader.close();
            inps.close();
        }
        catch (IOException ex) {
            CoreUtil.throwAsRuntimeException(ex);
        }
        catch (RuntimeException runtimeException) {}
    }

    private String merge(String metaInf) {
        this.mergeList_ = new ArrayList();
        String[] val = this.mergeInf_.split(",");
        int i = 0;
        while (i < val.length) {
            this.mergeList_.add(val[i]);
            ++i;
        }
        i = 0;
        while (i < this.mergeList_.size()) {
            String mergeInf = this.mergeList_.get(i);
            if (metaInf.indexOf(mergeInf) >= 0) {
                metaInf = mergeInf;
                break;
            }
            ++i;
        }
        return metaInf;
    }

    public void setMetaElement(String metaEle) {
        this.metaElement_ = metaEle;
    }

    public void setMergeMetaInf(String metaInf) {
        this.mergeInf_ = metaInf;
    }
}

