/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime.filter.file.label;

import java.util.concurrent.TimeUnit;
import jp.hasc.hasctool.core.data.EnumCommand;
import jp.hasc.hasctool.core.data.SignalMessage;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;
import jp.hasc.hasctool.core.runtime.filter.file.label.LabelLine;
import jp.hasc.hasctool.core.util.CSVUtil;

public class LabelFileParser
extends AbstractFilter {
    private double timeUnitSeconds_ = 1.0;

    @Override
    public void processMessage(Object message) throws InterruptedException {
        if (message instanceof String) {
            String row = (String)message;
            if (row.startsWith("#")) {
                this.outputMessage(row);
            } else if (!row.isEmpty()) {
                String[] columns = CSVUtil.parseCSVRecord(row);
                LabelLine ll = new LabelLine();
                ll.timeBegin = this.secondToTime(Double.parseDouble(columns[0]));
                ll.timeEnd = this.secondToTime(Double.parseDouble(columns[1]));
                ll.label = columns[2];
                this.outputMessage(ll);
            }
        } else if (message == EnumCommand.BEGIN) {
            this.outputMessage(message);
        } else {
            this.outputMessage(message);
        }
    }

    public long secondToTime(double secs) {
        return SignalMessage.TIME_UNIT.convert((long)(secs * this.timeUnitSeconds_ * 1000000.0), TimeUnit.MICROSECONDS);
    }

    public double getTimeUnitSeconds() {
        return this.timeUnitSeconds_;
    }

    public void setTimeUnitSeconds(double timeUnitSeconds) {
        this.timeUnitSeconds_ = timeUnitSeconds;
    }
}

