/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime.filter.file.label;

import java.util.TreeMap;
import jp.hasc.hasctool.core.data.LabelInfo;
import jp.hasc.hasctool.core.data.LabelSignalMessage;
import jp.hasc.hasctool.core.data.SignalMessage;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;
import jp.hasc.hasctool.core.util.CSVUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LabelToCSVFilter
extends AbstractFilter {
    private static final Log LOG = LogFactory.getLog(LabelToCSVFilter.class);
    private TreeMap<LabelInfo, LabelSignalMessage> currentBeginnningLabels_ = new TreeMap();

    @Override
    public void processMessage(Object message) throws InterruptedException {
        block11: {
            block10: {
                if (!(message instanceof LabelSignalMessage)) break block10;
                LabelSignalMessage sig = (LabelSignalMessage)message;
                LabelInfo li = sig.getLabelInfo();
                switch (sig.getType()) {
                    case BEGIN: {
                        if (this.currentBeginnningLabels_.containsKey(li)) {
                            throw new RuntimeException("duplicate BeginMessage for: " + li);
                        }
                        this.currentBeginnningLabels_.put(li, sig);
                        break block11;
                    }
                    case END: {
                        LabelSignalMessage beginSig = this.currentBeginnningLabels_.get(li);
                        if (beginSig == null) {
                            throw new RuntimeException("EndMessage without BeginMessage for: " + li);
                        }
                        this.currentBeginnningLabels_.remove(li);
                        this.outputMessage(CSVUtil.toCSVRecord(Double.toString((double)SignalMessage.TIME_UNIT.toMicros(beginSig.getTime()) / 1000000.0), Double.toString((double)SignalMessage.TIME_UNIT.toMicros(sig.getTime()) / 1000000.0), li.getLabel()));
                        break block11;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
            }
            if (message == SignalMessage.END) {
                if (!this.currentBeginnningLabels_.isEmpty()) {
                    LOG.warn((Object)("labels doesn't ended: " + this.currentBeginnningLabels_.keySet().toString()));
                }
                this.outputMessage(message);
            } else if (!(message instanceof SignalMessage)) {
                this.outputMessage(message);
            }
        }
    }
}

