/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime.filter.file.message;

import java.util.ArrayList;
import jp.hasc.hasctool.core.data.EnumCommand;
import jp.hasc.hasctool.core.messaging.MessageProcessor;
import jp.hasc.hasctool.core.messaging.MessageQueue;
import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.source.AbstractSource;

public class MessageMerger
extends AbstractSource {
    protected ArrayList<MessageQueue> inputPorts_ = new ArrayList();
    private int inputPortCount_;

    public int getInputPortCount() {
        return this.inputPortCount_;
    }

    public void setInputPortCount(int size) {
        this.inputPortCount_ = size;
    }

    public MessageProcessor getInputPort(int index) {
        return this.inputPorts_.get(index);
    }

    public MessageQueue createMessageQueue(int portIndex) {
        return this.getRuntimeContext().createDefaultMessageQueue();
    }

    @Override
    public void setup(RuntimeContext context) {
        super.setup(context);
        this.inputPorts_.clear();
        int i = 0;
        while (i < this.inputPortCount_) {
            this.inputPorts_.add(this.createMessageQueue(i));
            ++i;
        }
    }

    @Override
    protected void run() throws InterruptedException {
        int psize = this.getInputPortCount();
        this.outputMessage((Object)EnumCommand.BEGIN);
        int i = 0;
        while (i < psize) {
            MessageQueue queue = this.inputPorts_.get(i);
            Object message = queue.readMessage();
            if (message != EnumCommand.BEGIN) {
                throw new IllegalStateException("must be BEGIN");
            }
            ++i;
        }
        boolean done = false;
        while (!this.isShutdown() && !done) {
            StringBuilder sb = new StringBuilder();
            int i2 = 0;
            while (i2 < psize) {
                Object message = this.inputPorts_.get(i2).readMessage();
                if (message == EnumCommand.END) {
                    if (i2 == 0) {
                        done = true;
                    } else if (!done) {
                        throw new IllegalStateException("must be END for all the input ports");
                    }
                } else {
                    if (done) {
                        throw new IllegalStateException("must be END for all the input ports");
                    }
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(message.toString());
                }
                ++i2;
            }
            if (done) continue;
            this.outputMessage(sb.toString());
        }
        this.outputMessage((Object)EnumCommand.END);
    }
}

