/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime.filter.file.table;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.filter.file.table.AbstractElementFilter;
import jp.hasc.hasctool.core.util.CoreUtil;

public class AngleElementFilter
extends AbstractElementFilter {
    int axisNum_ = 3;
    String title_ = "atan(y/x),atan(z/y),atan(x/z)";

    @Override
    public void setup(RuntimeContext context) {
        super.setup(context);
        this.element_ = this.title_;
    }

    @Override
    String getFeature(String filePath) {
        double[] element = new double[this.axisNum_];
        double[] angle = new double[this.axisNum_];
        int[] count = new int[this.axisNum_];
        try {
            String line;
            InputStream inps = this.getRuntimeContext().getFileStreamProvider().openInputStream(filePath);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inps, RuntimeContext.DEFAULT_CHARSET));
            while ((line = bufferedReader.readLine()) != null) {
                String[] row = line.split(",");
                int i = 0;
                while (i < this.axisNum_) {
                    element[i] = Double.parseDouble(row[i + 1]);
                    ++i;
                }
                int j = 0;
                while (j < this.axisNum_) {
                    int next = (j + 1) % this.axisNum_;
                    if (element[j] != 0.0) {
                        int n = j;
                        angle[n] = angle[n] + Math.atan(element[next] / element[j]);
                        int n2 = j;
                        count[n2] = count[n2] + 1;
                    }
                    ++j;
                }
            }
            bufferedReader.close();
            inps.close();
        }
        catch (IOException ex) {
            CoreUtil.throwAsRuntimeException(ex);
        }
        catch (RuntimeException runtimeException) {}
        String row_ = "";
        int i = 0;
        while (i < this.axisNum_) {
            int n = i;
            angle[n] = angle[n] / (double)count[i];
            row_ = i != 0 ? String.valueOf(row_) + "," + angle[i] : String.valueOf(row_) + angle[i];
            ++i;
        }
        return row_;
    }
}

