/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime.filter.frequency;

import jp.hasc.hasctool.core.data.Complex;

public class FFT {
    private Complex[] input;
    private Complex[] output;
    private boolean inverse;
    private int length;

    public void setdata(Complex[] data) {
        this.length = data.length;
        this.input = data;
    }

    public Complex[] getdata() {
        return this.output;
    }

    public FFT(boolean inv) {
        this.inverse = inv;
    }

    public void execute() {
        this.output = new Complex[this.length];
        if (!this.inverse) {
            this.fft();
        } else {
            this.ifft();
        }
    }

    private void fft() {
        int N = this.length;
        if (N == 1) {
            this.output = new Complex[]{this.input[0]};
        } else {
            if (N % 2 != 0) {
                throw new RuntimeException("N is not a power of 2");
            }
            Complex[] even = new Complex[N / 2];
            int k = 0;
            while (k < N / 2) {
                even[k] = this.input[2 * k];
                ++k;
            }
            FFT fft = new FFT(false);
            fft.setdata(even);
            fft.execute();
            Complex[] q = fft.getdata();
            Complex[] odd = even;
            int k2 = 0;
            while (k2 < N / 2) {
                odd[k2] = this.input[2 * k2 + 1];
                ++k2;
            }
            fft = new FFT(false);
            fft.setdata(odd);
            fft.execute();
            Complex[] r = fft.getdata();
            int k3 = 0;
            while (k3 < N / 2) {
                double kth = (double)(-2 * k3) * Math.PI / (double)N;
                Complex wk = new Complex(Math.cos(kth), Math.sin(kth));
                this.output[k3] = q[k3].plus(wk.times(r[k3]));
                this.output[k3 + N / 2] = q[k3].minus(wk.times(r[k3]));
                ++k3;
            }
        }
    }

    private void ifft() {
        int N = this.length;
        Complex[] val = new Complex[N];
        int i = 0;
        while (i < N) {
            val[i] = this.input[i].conjugate();
            ++i;
        }
        FFT fft = new FFT(false);
        fft.setdata(val);
        fft.execute();
        val = fft.getdata();
        int i2 = 0;
        while (i2 < N) {
            val[i2] = val[i2].conjugate();
            ++i2;
        }
        i2 = 0;
        while (i2 < N) {
            this.output[i2] = val[i2].times(1.0 / (double)N);
            ++i2;
        }
    }
}

