/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime.filter.frequency;

import jp.hasc.hasctool.core.data.Complex;
import jp.hasc.hasctool.core.data.ComplexVectorSignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessage;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;
import jp.hasc.hasctool.core.runtime.filter.frequency.FFT;

public class FFTFilter
extends AbstractFilter {
    private FFT fft;

    @Override
    public void processMessage(Object message) throws InterruptedException {
        if (message instanceof VectorSignalMessage) {
            VectorSignalMessage vsig = (VectorSignalMessage)message;
            Complex[] data = new Complex[vsig.getVectorSize()];
            int i = 0;
            while (i < data.length) {
                data[i] = new Complex(vsig.getVectorElement(i), 0.0);
                ++i;
            }
            this.fft = new FFT(false);
            this.fft.setdata(data);
            this.fft.execute();
            Complex[] newValue = this.fft.getdata();
            this.outputMessage(new ComplexVectorSignalMessage(vsig.getTime(), newValue, true));
        } else {
            this.outputMessage(message);
        }
    }
}

