/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime.filter.frequency;

import jp.hasc.hasctool.core.data.Complex;
import jp.hasc.hasctool.core.data.ComplexVectorSignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessages;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;
import jp.hasc.hasctool.core.runtime.filter.frequency.FFT;

public class InverseFFTFilter
extends AbstractFilter {
    private FFT fft;

    @Override
    public void processMessage(Object message) throws InterruptedException {
        if (message instanceof ComplexVectorSignalMessage) {
            VectorSignalMessage cvsig = (VectorSignalMessage)message;
            Complex[] data = new Complex[cvsig.getVectorSize()];
            int i = 0;
            while (i < data.length) {
                data[i] = ((ComplexVectorSignalMessage)cvsig).getVectorValue(i);
                ++i;
            }
            this.fft = new FFT(true);
            this.fft.setdata(data);
            this.fft.execute();
            Complex[] data2 = this.fft.getdata();
            int len = data2.length - data2.length / 2;
            double newValue = data2[len].re();
            this.outputMessage(VectorSignalMessages.createScalar(cvsig.getTime(), newValue));
        } else {
            this.outputMessage(message);
        }
    }
}

