/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime.filter.frequency;

import jp.hasc.hasctool.core.data.Complex;
import jp.hasc.hasctool.core.data.ScalarSignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessages;
import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;
import jp.hasc.hasctool.core.runtime.filter.frequency.FFT;
import jp.hasc.hasctool.core.runtime.filter.window.WindowFunction;

public class LowPassFilter
extends AbstractFilter {
    private int length_;
    private Complex[] input_;
    private int next_;
    private boolean fill_;
    private int cutoffFrequency_;
    private FFT fft_;
    private WindowFunction wf_;

    @Override
    public void setup(RuntimeContext context) {
        super.setup(context);
        if (this.cutoffFrequency_ > this.length_) {
            this.cutoffFrequency_ = this.length_;
        }
        this.input_ = new Complex[this.length_];
        this.next_ = 0;
    }

    public void setSampleNum(int samplenum) {
        this.length_ = samplenum;
    }

    public void setCutoffFrequency(int cf) {
        this.cutoffFrequency_ = cf;
    }

    protected void setdata(Complex data) {
        this.input_[this.next_] = data;
        this.next_ = (this.next_ + 1) % this.length_;
    }

    @Override
    public void processMessage(Object message) throws InterruptedException {
        if (message instanceof ScalarSignalMessage) {
            ScalarSignalMessage ssig = (ScalarSignalMessage)message;
            this.setdata(new Complex(ssig.getScalarValue(), 0.0));
            if (this.next_ == 0 && !this.fill_) {
                this.fill_ = true;
            }
            if (this.fill_) {
                Complex[] data = new Complex[this.length_];
                int i = 0;
                while (i < this.length_) {
                    int j = (i + this.next_) % this.length_;
                    data[i] = this.input_[j];
                    ++i;
                }
                this.wf_ = new WindowFunction();
                data = this.wf_.WindowHanning(data);
                this.fft_ = new FFT(false);
                this.fft_.setdata(data);
                this.fft_.execute();
                Complex[] data2 = this.fft_.getdata();
                int cf = this.cutoffFrequency_;
                int i2 = 0;
                while (i2 < this.length_) {
                    int j = i2 + 1;
                    if (j > cf && j < this.length_ + 1 - cf) {
                        data2[i2] = new Complex(0.0, 0.0);
                    }
                    ++i2;
                }
                this.fft_ = new FFT(true);
                this.fft_.setdata(data2);
                this.fft_.execute();
                Complex[] data3 = this.fft_.getdata();
                double[] newValue = new double[]{data3[this.length_ / 2].re()};
                this.outputMessage(VectorSignalMessages.create(ssig.getTime(), newValue));
            }
        } else {
            this.outputMessage(message);
        }
    }
}

