/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime.filter.frequency;

import jp.hasc.hasctool.core.data.Complex;
import jp.hasc.hasctool.core.data.ComplexVectorSignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessage;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;

public class PassFrequencyFilter
extends AbstractFilter {
    private int startF_;
    private int endF_;

    public void setStartFrequency(int sf) {
        this.startF_ = sf;
    }

    public void setEndFrequency(int ef) {
        this.endF_ = ef;
    }

    @Override
    public void processMessage(Object message) throws InterruptedException {
        if (message instanceof ComplexVectorSignalMessage) {
            VectorSignalMessage cvsig = (VectorSignalMessage)message;
            int len = cvsig.getVectorSize();
            Complex[] newValue = new Complex[len];
            int i = 0;
            while (i < len) {
                int j = i + 1;
                newValue[i] = j < this.startF_ ? new Complex(0.0, 0.0) : (this.endF_ < j && j < len + 1 - this.endF_ ? new Complex(0.0, 0.0) : (len + 1 - this.startF_ < j ? new Complex(0.0, 0.0) : ((ComplexVectorSignalMessage)cvsig).getVectorValue(i)));
                ++i;
            }
            this.outputMessage(new ComplexVectorSignalMessage(cvsig.getTime(), newValue, true));
        } else {
            this.outputMessage(message);
        }
    }
}

