/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime.filter.interpolator;

import java.util.ArrayList;
import jp.hasc.hasctool.core.data.SignalMessage;
import jp.hasc.hasctool.core.messaging.MessageConnector;
import jp.hasc.hasctool.core.messaging.MessageProcessor;
import jp.hasc.hasctool.core.messaging.MessageQueue;
import jp.hasc.hasctool.core.runtime.AbstractTask;
import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.filter.interpolator.SignalInterpolator;

public abstract class AbstractMultipleInputsFilter
extends AbstractTask {
    protected ArrayList<MessageQueue> inputPorts_ = new ArrayList();
    protected ArrayList<SignalInterpolator> interpolators_ = new ArrayList();
    protected int primaryInputPortIndex_;
    protected int inputPortCount_ = 0;
    private MessageConnector outputPort_ = new MessageConnector();

    public MessageConnector getOutputPort() {
        return this.outputPort_;
    }

    protected void outputMessage(Object message) throws InterruptedException {
        this.getOutputPort().processMessage(message);
    }

    public int getInputPortCount() {
        return this.inputPortCount_;
    }

    public void setInputPortCount(int size) {
        this.inputPortCount_ = size;
    }

    public MessageProcessor getInputPort(int index) {
        return this.inputPorts_.get(index);
    }

    public int getInputPortIndex(MessageProcessor idx) {
        return this.inputPorts_.indexOf(idx);
    }

    public abstract SignalInterpolator createSignalInterpolator(int var1);

    public MessageQueue createMessageQueue(int portIndex) {
        return this.getRuntimeContext().createDefaultMessageQueue();
    }

    @Override
    public void setup(RuntimeContext context) {
        super.setup(context);
        this.interpolators_.clear();
        this.inputPorts_.clear();
        int i = 0;
        while (i < this.inputPortCount_) {
            this.interpolators_.add(this.createSignalInterpolator(i));
            this.inputPorts_.add(this.createMessageQueue(i));
            ++i;
        }
    }

    public int getPrimaryInputPortIndex() {
        return this.primaryInputPortIndex_;
    }

    public void setPrimaryInputPortIndex(int timerPortIndex) {
        this.primaryInputPortIndex_ = timerPortIndex;
    }

    @Override
    protected void run() throws InterruptedException {
        int psize = this.getInputPortCount();
        SignalMessage[] current = new SignalMessage[psize];
        int[] portState = new int[psize];
        int i = 0;
        while (i < psize) {
            portState[i] = 1;
            ++i;
        }
        this.outputMessage((Object)SignalMessage.BEGIN);
        block1: while (!this.isShutdown()) {
            int pi = this.primaryInputPortIndex_;
            MessageQueue p_port = this.inputPorts_.get(pi);
            Object p_obj = p_port.readMessage();
            if (p_obj instanceof SignalMessage) {
                SignalMessage p_sig = (SignalMessage)p_obj;
                SignalInterpolator p_itp = this.interpolators_.get(pi);
                if (!this.acceptSignalMessage(pi, p_sig) || !p_itp.addSample(p_sig)) {
                    this.processUnacceptedSignalMessage(pi, p_sig);
                    continue;
                }
                current[pi] = p_sig;
                SignalMessage[] result = new SignalMessage[psize];
                long p_time = p_sig.getTime();
                result[pi] = p_itp.getAtTime(p_time);
                int i2 = 0;
                while (i2 < psize) {
                    if (i2 != pi) {
                        SignalInterpolator i_itp = this.interpolators_.get(i2);
                        if (portState[i2] == 2) {
                            result[i2] = i_itp.getAtTime(p_time);
                        } else {
                            MessageQueue i_port = this.inputPorts_.get(i2);
                            SignalMessage i_cursig = current[i2];
                            while (i_cursig == null || i_cursig.getTime() < p_time) {
                                if (this.isShutdown()) break block1;
                                Object i_obj = i_port.readMessage();
                                if (i_obj instanceof SignalMessage) {
                                    SignalMessage i_sig = (SignalMessage)i_obj;
                                    if (!this.acceptSignalMessage(i2, i_sig) || !i_itp.addSample(i_sig)) {
                                        this.processUnacceptedSignalMessage(i2, i_sig);
                                        continue;
                                    }
                                    i_cursig = i_sig;
                                    continue;
                                }
                                if (i_obj == SignalMessage.BEGIN) continue;
                                if (i_obj == SignalMessage.END) {
                                    portState[i2] = 2;
                                    break;
                                }
                                this.processOtherMessage(i2, i_obj);
                            }
                            current[i2] = i_cursig;
                            result[i2] = i_itp.getAtTime(p_time);
                        }
                    }
                    ++i2;
                }
                this.processSignalMessages(p_time, result);
                continue;
            }
            if (p_obj == SignalMessage.BEGIN) continue;
            if (p_obj == SignalMessage.END) {
                portState[pi] = 2;
                break;
            }
            this.processOtherMessage(pi, p_obj);
        }
        this.outputMessage((Object)SignalMessage.END);
    }

    protected void processOtherMessage(int portIndex, Object message) throws InterruptedException {
        if (portIndex == this.primaryInputPortIndex_) {
            this.outputMessage(message);
        }
    }

    protected void processUnacceptedSignalMessage(int portIndex, SignalMessage signalMessage) throws InterruptedException {
    }

    protected boolean acceptSignalMessage(int portIndex, SignalMessage signalMessage) {
        return true;
    }

    protected abstract void processSignalMessages(long var1, SignalMessage[] var3) throws InterruptedException;
}

