/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime.filter.interpolator;

import jp.hasc.hasctool.core.data.SignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessages;
import jp.hasc.hasctool.core.runtime.filter.interpolator.SignalInterpolator;

public class LinearVectorInterporator
implements SignalInterpolator {
    private VectorSignalMessage previous_ = null;
    private VectorSignalMessage next_ = null;

    @Override
    public boolean addSample(SignalMessage message) {
        if (message instanceof VectorSignalMessage) {
            this.previous_ = this.next_;
            this.next_ = (VectorSignalMessage)message;
            return true;
        }
        return false;
    }

    @Override
    public SignalMessage getAtTime(long time) {
        long ptime;
        if (this.next_ == null) {
            return null;
        }
        if (this.previous_ == null) {
            return this.next_.createDelayedElement(time - this.next_.getTime());
        }
        long ntime = this.next_.getTime();
        if (ntime - (ptime = this.previous_.getTime()) == 0L) {
            return this.next_;
        }
        double p = (double)(time - ptime) / (double)(ntime - ptime);
        int vsize = Math.min(this.previous_.getVectorSize(), this.next_.getVectorSize());
        if (vsize == 1) {
            double val = this.previous_.getVectorElement(0) * (1.0 - p) + this.next_.getVectorElement(0) * p;
            return VectorSignalMessages.createScalar(time, val);
        }
        double[] vals = new double[vsize];
        int i = 0;
        while (i < vsize) {
            vals[i] = this.previous_.getVectorElement(i) * (1.0 - p) + this.next_.getVectorElement(i) * p;
            ++i;
        }
        return VectorSignalMessages.create(time, vals, false);
    }
}

