/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime.filter.interpolator;

import jp.hasc.hasctool.core.data.SignalMessage;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;
import jp.hasc.hasctool.core.runtime.filter.interpolator.SignalInterpolator;

public class PeriodicSignalSampler
extends AbstractFilter {
    private boolean started_ = false;
    private SignalInterpolator interpolator_;
    private long nextTime_ = 0L;
    private long timeStep_ = 0L;

    public void setInitialTime(long time) {
        if (this.started_) {
            throw new IllegalStateException();
        }
        this.nextTime_ = time;
        this.started_ = true;
    }

    @Override
    public void processMessage(Object message) throws InterruptedException {
        if (message instanceof SignalMessage) {
            SignalMessage sig = (SignalMessage)message;
            long time = sig.getTime();
            if (!this.started_) {
                this.started_ = true;
                this.nextTime_ = time;
                long mod = this.nextTime_ % this.timeStep_;
                if (mod > 0L) {
                    this.nextTime_ += this.timeStep_ - mod;
                } else if (mod < 0L) {
                    this.nextTime_ -= mod;
                }
            }
            if (this.nextTime_ <= time && this.interpolator_.addSample(sig)) {
                while (this.nextTime_ <= time) {
                    this.outputMessage(this.interpolator_.getAtTime(this.nextTime_));
                    this.nextTime_ += this.timeStep_;
                }
            }
        } else {
            this.outputMessage(message);
        }
    }

    public SignalInterpolator getInterpolator() {
        return this.interpolator_;
    }

    public void setInterpolator(SignalInterpolator interpolator) {
        this.interpolator_ = interpolator;
    }

    public long getTimeStep() {
        return this.timeStep_;
    }

    public void setTimeStep(long timeStep) {
        if (timeStep <= 0L) {
            throw new IllegalArgumentException();
        }
        this.timeStep_ = timeStep;
    }
}

