/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime.filter.label;

import jp.hasc.hasctool.core.data.SignalMessage;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;
import jp.hasc.hasctool.core.runtime.filter.tick.TickEmitter;

public abstract class AbstractLabelingFilter
extends AbstractFilter {
    private String targetFilePath_ = null;
    private TickEmitter tickEmitter_ = null;

    @Override
    public void processMessage(Object message) throws InterruptedException {
        if (message instanceof SignalMessage) {
            SignalMessage sig = (SignalMessage)message;
            this.processSignalMessage(sig);
            if (this.tickEmitter_ != null) {
                this.tickEmitter_.afterProcessSignalMessage(sig);
            }
        } else if (message == SignalMessage.BEGIN) {
            this.outputMessage(message);
            if (this.targetFilePath_ != null) {
                this.outputMessage("#targetfile:" + this.targetFilePath_);
            }
        } else {
            this.outputMessage(message);
        }
    }

    @Override
    protected void outputMessage(Object message) throws InterruptedException {
        if (message instanceof SignalMessage) {
            SignalMessage sig = (SignalMessage)message;
            if (this.tickEmitter_ != null) {
                this.tickEmitter_.onOutputSignalMessage(sig);
            }
        }
        super.outputMessage(message);
    }

    protected abstract void processSignalMessage(SignalMessage var1) throws InterruptedException;

    public void setTickEmitter(TickEmitter tickEmitter) {
        this.tickEmitter_ = tickEmitter;
        this.tickEmitter_.setInputPortToOutputMessage(this.getInputPortToOutputMessage());
    }

    public String getTargetFilePath() {
        return this.targetFilePath_;
    }

    public void setTargetFilePath(String targetFileName) {
        this.targetFilePath_ = targetFileName;
    }

    public TickEmitter getTickEmitter() {
        return this.tickEmitter_;
    }
}

