/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime.filter.time;

import jp.hasc.hasctool.core.data.VectorSignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessages;
import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;

public class RelativeTimeFilter
extends AbstractFilter {
    private long startTime_;
    private boolean start_;

    @Override
    public void setup(RuntimeContext context) {
        super.setup(context);
        this.start_ = true;
    }

    long getReTime(long val) {
        return val - this.startTime_;
    }

    long timeParse(long val) {
        long hour = (int)(val / 10000000L);
        long minute = (long)((int)(val / 100000L)) - hour * 100L;
        long msec = val - (hour * 10000000L + minute * 100000L);
        return hour * 3600L * 1000L + minute * 60L * 1000L + msec;
    }

    @Override
    public void processMessage(Object message) throws InterruptedException {
        if (message instanceof VectorSignalMessage) {
            VectorSignalMessage vsig = (VectorSignalMessage)message;
            double[] newValue = new double[vsig.getVectorSize()];
            int i = 0;
            while (i < newValue.length) {
                newValue[i] = vsig.getVectorElement(i);
                ++i;
            }
            if (this.start_) {
                this.startTime_ = vsig.getTime();
                this.start_ = false;
            }
            long newTime = this.getReTime(vsig.getTime());
            this.outputMessage(VectorSignalMessages.create(newTime, newValue));
        } else {
            this.outputMessage(message);
        }
    }
}

