/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime.filter.window;

import jp.hasc.hasctool.core.data.ScalarSignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessages;
import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;

public abstract class AbstractWindowFunctionFilter
extends AbstractFilter {
    private long[] time_;
    private double[] sampleData_;
    private int next_;
    private boolean fill_;
    protected int length_;

    @Override
    public void setup(RuntimeContext context) {
        super.setup(context);
        this.time_ = new long[this.length_];
        this.sampleData_ = new double[this.length_];
        this.next_ = 0;
        this.fill_ = false;
    }

    public void setSampleNum(int samplenum) {
        this.length_ = samplenum;
    }

    private void setTime(long time) {
        this.time_[this.next_] = time;
    }

    protected void setdata(double data) {
        this.sampleData_[this.next_] = data;
        this.next_ = (this.next_ + 1) % this.length_;
    }

    @Override
    public void processMessage(Object message) throws InterruptedException {
        if (message instanceof ScalarSignalMessage) {
            ScalarSignalMessage ssig = (ScalarSignalMessage)message;
            this.setTime(ssig.getTime());
            this.setdata(ssig.getScalarValue());
            if (this.next_ == 0 && !this.fill_) {
                this.fill_ = true;
            }
            if (this.fill_) {
                long stime = this.time_[this.next_];
                double[] newValue = this.windowFunction(this.sampleData_, this.next_);
                this.outputMessage(VectorSignalMessages.create(stime, newValue));
            }
        } else {
            this.outputMessage(message);
        }
    }

    protected abstract double[] windowFunction(double[] var1, int var2);
}

