/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime.filter.window;

import jp.hasc.hasctool.core.data.Complex;

public class WindowFunction {
    double PI = Math.PI;
    Complex[] output_;

    public Complex[] WindowHanning(Complex[] input) {
        int N = input.length;
        this.output_ = new Complex[N];
        int n = 0;
        while (n < N) {
            double val = 0.5 - 0.5 * Math.cos(2.0 * this.PI * (double)n / (double)(N - 1));
            this.output_[n] = input[n].times(val);
            ++n;
        }
        return this.output_;
    }

    public Complex[] WindowHamming(Complex[] input) {
        int N = input.length;
        this.output_ = new Complex[N];
        int n = 0;
        while (n < N) {
            double val = 0.54 - 0.46 * Math.cos(2.0 * this.PI * (double)n / (double)(N - 1));
            this.output_[n] = input[n].times(val);
            ++n;
        }
        return this.output_;
    }

    public Complex[] WindowBlackman(Complex[] input, int index) {
        int N = input.length;
        this.output_ = new Complex[N];
        int n = 0;
        while (n < N) {
            double val = 0.42 - 0.5 * Math.cos(2.0 * this.PI * (double)n / (double)(N - 1)) + 0.08 * Math.cos(4.0 * this.PI * (double)n / (double)(N - 1));
            this.output_[n] = input[n].times(val);
            ++n;
        }
        return this.output_;
    }

    public Complex[] WindowGaussian(Complex[] input, int index, double k) {
        int N = input.length;
        this.output_ = new Complex[N];
        int n = 0;
        while (n < N) {
            double val1 = Math.pow(n - (N - 1) / 2, 2.0);
            double val2 = -2.0 * k * k / Math.pow(N - 1, 2.0);
            double val = Math.exp(val1 * val2);
            this.output_[n] = input[n].times(val);
            ++n;
        }
        return this.output_;
    }
}

