/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime.hierarchize;

import com.thoughtworks.xstream.XStream;
import java.io.InputStreamReader;
import java.util.Map;
import jp.hasc.hasctool.core.blockdiagram.BlockDiagramExecutor;
import jp.hasc.hasctool.core.blockdiagram.model.BlockDiagram;
import jp.hasc.hasctool.core.runtime.FileStreamProvider;
import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.hierarchize.XbdExecutionRequest;
import jp.hasc.hasctool.core.util.CoreUtil;
import jp.hasc.hasctool.ui.commands.BlockDiagramExecutorManager;
import jp.hasc.hasctool.ui.commands.ResourceStreamProvider;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IWorkbenchWindow;

public class InnerXbdExecutor {
    private static final Log LOG = LogFactory.getLog(InnerXbdExecutor.class);
    private RuntimeContext outerContext_;
    private BlockDiagramExecutor innerExecutor_;

    public void load(RuntimeContext outerContext, XbdExecutionRequest req) {
        try {
            this.outerContext_ = outerContext;
            String xbdFilePath = req.getXbdFilePath();
            FileStreamProvider fsp = outerContext.getFileStreamProvider();
            this.innerExecutor_ = new BlockDiagramExecutor(new RuntimeContext(this.outerContext_));
            RuntimeContext innerContext = this.innerExecutor_.getRuntimeContext();
            innerContext.putObjectToRepogitory(IWorkbenchWindow.class, outerContext.getObjectFromRepogitory(IWorkbenchWindow.class));
            if (fsp instanceof ResourceStreamProvider) {
                ResourceStreamProvider rsp = (ResourceStreamProvider)fsp;
                IFile innerXbdFile = rsp.getFile(xbdFilePath);
                innerContext.putObjectToRepogitory("blockDiagramFileName", (Object)innerXbdFile.getName());
                innerContext.setFileStreamProvider(new ResourceStreamProvider(innerXbdFile.getParent(), innerContext));
            } else {
                innerContext.setFileStreamProvider(fsp);
            }
            String contents = CoreUtil.readReaderAsString(new InputStreamReader(fsp.openInputStream(xbdFilePath), RuntimeContext.DEFAULT_CHARSET));
            XStream xs = BlockDiagramExecutor.newXStream();
            BlockDiagram bd = (BlockDiagram)xs.fromXML(InnerXbdExecutor.preprocessXbd(contents, req));
            this.innerExecutor_.doLoad(bd);
            this.innerExecutor_.doCreateInstances();
            this.modifyProperties(req);
            this.innerExecutor_.doSetup();
            this.innerExecutor_.doConnect();
        }
        catch (Exception ex) {
            CoreUtil.throwAsRuntimeException(ex);
        }
    }

    private void modifyProperties(XbdExecutionRequest req) {
        for (Map.Entry<String, Object> e : req.getProperties().entrySet()) {
            String key = e.getKey();
            int idx = key.indexOf(46);
            if (idx < 0) {
                LOG.warn((Object)("invalid property key: " + key));
                continue;
            }
            String blockName = key.substring(0, idx);
            String propName = key.substring(idx + 1);
            Object bean = this.innerExecutor_.getBlockInsance(blockName);
            if (bean == null) {
                LOG.warn((Object)("block not found: " + blockName));
                continue;
            }
            try {
                PropertyUtils.setProperty((Object)bean, (String)propName, (Object)e.getValue());
            }
            catch (Exception ex) {
                LOG.warn((Object)"Exception", (Throwable)ex);
            }
        }
    }

    private static String preprocessXbd(String contents, XbdExecutionRequest req) {
        for (Map.Entry<String, String> e : req.getReplacingsInXbd().entrySet()) {
            if (!contents.contains(e.getKey())) continue;
            contents = contents.replace(e.getKey(), e.getValue());
        }
        contents = BlockDiagramExecutorManager.preprocess_currentDateTime(contents);
        return contents;
    }

    public void start() {
        this.outerContext_.addChildContext(this.innerExecutor_.getRuntimeContext());
        this.innerExecutor_.doStart();
        this.getInnerContext().addTasksTerminationListener(new Runnable(){

            @Override
            public void run() {
                InnerXbdExecutor.this.outerContext_.removeChildContext(InnerXbdExecutor.this.innerExecutor_.getRuntimeContext());
            }
        });
    }

    public void awaitTasksTermination() throws InterruptedException {
        this.getInnerContext().awaitTasksTermination();
    }

    public BlockDiagramExecutor getInnerExecutor() {
        return this.innerExecutor_;
    }

    public RuntimeContext getInnerContext() {
        return this.innerExecutor_.getRuntimeContext();
    }

    public RuntimeContext getOuterContext() {
        return this.outerContext_;
    }
}

