/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime.hierarchize;

import jp.hasc.hasctool.core.blockdiagram.BlockDiagramExecutor;
import jp.hasc.hasctool.core.blockdiagram.model.PortReference;
import jp.hasc.hasctool.core.messaging.MessageConnector;
import jp.hasc.hasctool.core.messaging.MessageProcessor;
import jp.hasc.hasctool.core.runtime.AbstractTask;
import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.hierarchize.InnerXbdExecutor;
import jp.hasc.hasctool.core.runtime.hierarchize.XbdExecutionRequest;

public class XbdBlock
extends AbstractTask {
    private String innerInputPortName_ = null;
    private String innerOutputPortName_ = null;
    private String xbdFilePath_ = null;
    private XbdExecutionRequest xbdExecutionRequest_ = null;
    private InnerXbdExecutor xbdExecutor_ = new InnerXbdExecutor();

    @Override
    public void setup(RuntimeContext outerContext) {
        super.setup(outerContext);
        if (this.xbdExecutionRequest_ == null) {
            this.xbdExecutionRequest_ = new XbdExecutionRequest();
            this.xbdExecutionRequest_.setXbdFilePath(this.xbdFilePath_);
        } else if (this.xbdFilePath_ != null) {
            this.xbdExecutionRequest_.setXbdFilePath(this.xbdFilePath_);
        }
        this.xbdExecutor_.load(outerContext, this.xbdExecutionRequest_);
    }

    @Override
    protected void run() throws InterruptedException {
        this.xbdExecutor_.start();
        this.xbdExecutor_.awaitTasksTermination();
    }

    public static PortReference createPortReferenceFromString(String portProp) {
        int pos = portProp.indexOf(46);
        if (pos < 0) {
            throw new IllegalArgumentException();
        }
        String blockName = portProp.substring(0, pos);
        String portName = portProp.substring(pos + 1);
        return new PortReference(blockName, portName);
    }

    private BlockDiagramExecutor getInnerExecutor() {
        return this.xbdExecutor_.getInnerExecutor();
    }

    public MessageProcessor getInputPort() {
        if (this.innerInputPortName_ != null) {
            return (MessageProcessor)this.getInnerExecutor().getPort(XbdBlock.createPortReferenceFromString(this.innerInputPortName_));
        }
        return (MessageProcessor)this.getInnerExecutor().getPort(new PortReference("input", "inputPort"));
    }

    public MessageConnector getOutputPort() {
        if (this.innerOutputPortName_ != null) {
            return (MessageConnector)this.getInnerExecutor().getPort(XbdBlock.createPortReferenceFromString(this.innerOutputPortName_));
        }
        return (MessageConnector)this.getInnerExecutor().getPort(new PortReference("output", "outputPort"));
    }

    public void setXbdFilePath(String xbdFilePath) {
        this.xbdFilePath_ = xbdFilePath;
    }

    public void setInnerInputPortName(String innerInputPort) {
        this.innerInputPortName_ = innerInputPort;
    }

    public void setInnerOutputPortName(String innerOutputPort) {
        this.innerOutputPortName_ = innerOutputPort;
    }

    public void setXbdExecutionRequest(XbdExecutionRequest xbdExecutionRequest) {
        this.xbdExecutionRequest_ = xbdExecutionRequest;
    }
}

