/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime.hierarchize;

import jp.hasc.hasctool.core.data.EnumCommand;
import jp.hasc.hasctool.core.messaging.MessageProcessor;
import jp.hasc.hasctool.core.messaging.MessageQueue;
import jp.hasc.hasctool.core.runtime.AbstractTask;
import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.hierarchize.InnerXbdExecutor;
import jp.hasc.hasctool.core.runtime.hierarchize.XbdExecutionRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XbdExecutor
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(XbdExecutor.class);
    private MessageQueue inputQueue_;
    private String defaultXbdFilePath_ = null;
    private boolean shutdown_ = false;

    public MessageProcessor getInputPort() {
        return this.inputQueue_;
    }

    @Override
    public void setup(RuntimeContext context) {
        super.setup(context);
        this.inputQueue_ = context.createDefaultMessageQueue();
    }

    @Override
    protected void run() throws InterruptedException {
        RuntimeContext outerContext = this.getRuntimeContext();
        while (!this.shutdown_) {
            Object message = this.inputQueue_.readMessage();
            if (message instanceof XbdExecutionRequest) {
                XbdExecutionRequest req = (XbdExecutionRequest)message;
                if (req.getXbdFilePath() == null) {
                    req.setXbdFilePath(this.defaultXbdFilePath_);
                }
                if (req.getXbdFilePath() == null) {
                    throw new NullPointerException("xbdFilePath==null");
                }
                LOG.debug((Object)("execute " + req.getXbdFilePath()));
                InnerXbdExecutor innerXbdExecutor = new InnerXbdExecutor();
                innerXbdExecutor.load(outerContext, req);
                innerXbdExecutor.start();
                innerXbdExecutor.awaitTasksTermination();
                continue;
            }
            if (message != EnumCommand.END) continue;
            this.shutdown_ = true;
        }
    }

    public void setDefaultXbdFilePath(String defaultXbdFilePath) {
        this.defaultXbdFilePath_ = defaultXbdFilePath;
    }
}

