/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime.sink;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import jp.hasc.hasctool.core.data.EnumCommand;
import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.sink.AbstractSink;

public class ExtensionWriterSink
extends AbstractSink {
    private ArrayList<String> dataList_;
    private String filePath_;
    private String fileName_;
    private String feature_;
    private String folderPath_;

    public void setInputFilePath(String inputPath) {
        String[] fnVal = inputPath.split("/");
        this.fileName_ = fnVal[fnVal.length - 1];
    }

    public void setOutputFolder(String folderPath) {
        this.folderPath_ = folderPath;
    }

    public void setFeature(String feature) {
        this.feature_ = feature;
    }

    @Override
    public void processMessage(Object message) throws InterruptedException {
        if (message instanceof String) {
            this.dataList_.add((String)message);
        } else if (message == EnumCommand.BEGIN) {
            this.dataList_ = new ArrayList();
        } else if (message == EnumCommand.END) {
            this.filePath_ = String.valueOf(this.folderPath_) + "/" + this.feature_ + "_" + this.fileName_;
            if (this.filePath_ != null) {
                try {
                    FileOutputStream outs = new FileOutputStream(this.filePath_);
                    PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)outs, RuntimeContext.DEFAULT_CHARSET));
                    int i = 0;
                    while (i < this.dataList_.size()) {
                        writer.println(this.dataList_.get(i));
                        ++i;
                    }
                    writer.close();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.dataList_.add(message.toString());
        }
    }
}

