/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime.sink;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import jp.hasc.hasctool.core.data.EnumCommand;
import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.sink.AbstractSink;

public class LineWriterSink
extends AbstractSink {
    private PrintWriter writer_;
    private String filePath_;

    @Override
    public void setup(RuntimeContext context) {
        super.setup(context);
        if (this.filePath_ != null && this.writer_ == null) {
            OutputStream outs = this.getRuntimeContext().getFileStreamProvider().openOutputStream(this.filePath_);
            this.setWriter(new OutputStreamWriter(outs, RuntimeContext.DEFAULT_CHARSET));
        }
    }

    @Override
    public void processMessage(Object message) throws InterruptedException {
        if (message instanceof String) {
            this.writer_.println((String)message);
        } else if (message != EnumCommand.BEGIN) {
            if (message == EnumCommand.END) {
                this.writer_.close();
                this.writer_ = null;
            } else {
                this.writer_.println(message.toString());
            }
        }
    }

    public void setWriter(Writer writer) {
        this.writer_ = new PrintWriter(writer);
    }

    public void setFilePath(String filePath) {
        this.filePath_ = filePath;
    }
}

