/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime.source;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import jp.hasc.hasctool.core.data.SignalMessage;
import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.source.AbstractSource;
import jp.hasc.hasctool.core.util.CoreUtil;

public class LineReaderSource
extends AbstractSource {
    private String filePath_;
    private BufferedReader bufferedReader_;

    public void setReader(Reader reader) {
        this.bufferedReader_ = new BufferedReader(reader);
    }

    @Override
    public void setup(RuntimeContext context) {
        super.setup(context);
        if (this.filePath_ != null && this.bufferedReader_ == null) {
            try {
                InputStream inps = this.getRuntimeContext().getFileStreamProvider().openInputStream(this.filePath_);
                this.setReader(new InputStreamReader(inps, RuntimeContext.DEFAULT_CHARSET));
            }
            catch (RuntimeException ex) {
                CoreUtil.throwAsRuntimeException(ex);
            }
        }
    }

    @Override
    protected void run() throws InterruptedException {
        this.outputMessage((Object)SignalMessage.BEGIN);
        if (this.bufferedReader_ != null) {
            try {
                while (!this.isShutdown()) {
                    String line = this.bufferedReader_.readLine();
                    if (line == null) break;
                    this.outputMessage(line);
                }
                this.bufferedReader_.close();
            }
            catch (IOException ex) {
                CoreUtil.throwAsRuntimeException(ex);
            }
        }
        this.outputMessage((Object)SignalMessage.END);
    }

    public void setFilePath(String filePath) {
        this.filePath_ = filePath;
    }
}

