/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime.source;

import jp.hasc.hasctool.core.data.ScalarSignalMessage;
import jp.hasc.hasctool.core.data.SignalMessage;
import jp.hasc.hasctool.core.runtime.source.AbstractSource;

public class SinWaveGenerator
extends AbstractSource {
    private long cycle_;
    private long tickBegin_ = 0L;
    private long tickEnd_;
    private long tickInterval_;
    private double thetaOffset_ = 0.0;

    @Override
    protected void run() throws InterruptedException {
        long time = this.tickBegin_;
        this.outputMessage((Object)SignalMessage.BEGIN);
        while (time < this.tickEnd_ && !this.isShutdown()) {
            double val = Math.sin(Math.PI * 2 * (double)time / (double)this.cycle_ + this.thetaOffset_);
            this.outputMessage(new ScalarSignalMessage(time, val));
            time += this.tickInterval_;
        }
        this.outputMessage((Object)SignalMessage.END);
    }

    public long getCycle() {
        return this.cycle_;
    }

    public void setCycle(long cycle) {
        this.cycle_ = cycle;
    }

    public long getTickEnd() {
        return this.tickEnd_;
    }

    public void setTickEnd(long tickEnd) {
        this.tickEnd_ = tickEnd;
    }

    public long getTickInterval() {
        return this.tickInterval_;
    }

    public void setTickInterval(long tickInterval) {
        this.tickInterval_ = tickInterval;
    }

    public double getThetaOffset() {
        return this.thetaOffset_;
    }

    public void setThetaOffset(double offset) {
        this.thetaOffset_ = offset;
    }

    public long getTickBegin() {
        return this.tickBegin_;
    }

    public void setTickBegin(long tickBegin) {
        this.tickBegin_ = tickBegin;
    }
}

