/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime.source;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import jp.hasc.hasctool.core.data.SignalMessage;
import jp.hasc.hasctool.core.runtime.source.AbstractSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UDPStringReceiver
extends AbstractSource {
    private static final Log LOG = LogFactory.getLog(UDPStringReceiver.class);
    private static final int DEFAULT_UDP_PORT = 6666;
    private static final int UDP_TIMEOUT = 2000;
    private int port_ = 6666;
    private DatagramSocket socket_;

    @Override
    protected void run() throws InterruptedException {
        LOG.info((Object)("Receiving UDP packets on port " + this.port_ + "."));
        Charset charset = Charset.forName("UTF-8");
        byte[] buff = new byte[1024];
        DatagramPacket packet = new DatagramPacket(buff, buff.length);
        try {
            try {
                this.socket_ = new DatagramSocket(this.port_);
                this.socket_.setSoTimeout(2000);
                this.outputMessage((Object)SignalMessage.BEGIN);
                while (!this.isShutdown()) {
                    try {
                        this.socket_.receive(packet);
                        byte[] data = packet.getData();
                        String s = new String(data, packet.getOffset(), packet.getLength(), charset);
                        this.outputMessage(s);
                    }
                    catch (SocketTimeoutException socketTimeoutException) {}
                }
            }
            catch (IOException ex) {
                LOG.warn((Object)"IOException", (Throwable)ex);
                if (this.socket_ != null) {
                    this.socket_.close();
                }
                this.socket_ = null;
                this.outputMessage((Object)SignalMessage.END);
                LOG.info((Object)"closed.");
            }
        }
        finally {
            if (this.socket_ != null) {
                this.socket_.close();
            }
            this.socket_ = null;
            this.outputMessage((Object)SignalMessage.END);
            LOG.info((Object)"closed.");
        }
    }

    public int getPort() {
        return this.port_;
    }

    public void setPort(int udpPort) {
        this.port_ = udpPort;
    }
}

