/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.ui;

import java.io.IOException;
import java.io.Writer;
import jp.hasc.hasctool.ui.Activator;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class EclipseConsoleAppender
extends WriterAppender {
    private ILog log_;

    public void activateOptions() {
        MessageConsole console = new MessageConsole("HascTool", null);
        IConsoleManager consoleManger = ConsolePlugin.getDefault().getConsoleManager();
        consoleManger.addConsoles(new IConsole[]{console});
        final MessageConsoleStream consoleStream = console.newMessageStream();
        this.log_ = Activator.getDefault().getLog();
        this.setWriter(new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                String s = new String(cbuf, off, len);
                consoleStream.print(s);
            }

            @Override
            public void flush() throws IOException {
                consoleStream.flush();
            }

            @Override
            public void close() throws IOException {
                consoleStream.close();
            }
        });
        super.activateOptions();
    }

    protected void subAppend(LoggingEvent event) {
        if (event.getLevel().isGreaterOrEqual((Priority)Level.WARN)) {
            Throwable th = null;
            ThrowableInformation thi = event.getThrowableInformation();
            if (thi != null) {
                th = thi.getThrowable();
            }
            this.log_.log((IStatus)new Status(event.getLevel().isGreaterOrEqual((Priority)Level.ERROR) ? 4 : 2, "jp.hasc.hasctool.ui", event.getMessage().toString(), th));
        }
        super.subAppend(event);
    }
}

