/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.ui.commands;

import com.thoughtworks.xstream.XStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.hasc.hasctool.core.blockdiagram.BlockDiagramExecutor;
import jp.hasc.hasctool.core.blockdiagram.model.BlockDiagram;
import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.util.CoreUtil;
import jp.hasc.hasctool.ui.commands.Messages;
import jp.hasc.hasctool.ui.commands.ResourceStreamProvider;
import jp.hasc.hasctool.ui.util.UIUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;
import org.eclipse.ui.handlers.HandlerUtil;

public class BlockDiagramExecutorManager {
    public static final Pattern PAT_INPUT_FILE = Pattern.compile("\\$\\(inputFile\\.(\\w+)\\)");
    public static final Pattern PAT_CURRENT_DATETIME = Pattern.compile("\\$\\(currentDateTime\\)");
    private static final Log LOG = LogFactory.getLog(BlockDiagramExecutorManager.class);
    private static ArrayList<BlockDiagramExecutorManager> instances__ = new ArrayList();
    private IWorkbenchWindow window_;
    private BlockDiagramExecutor executor_ = null;
    private boolean iterateInputFiles_;
    private ResourceSelectionDialog intputFileDialog_;
    private IAdaptable inputFileDialogRootElement_;
    private ArrayList<IFile> inputFiles_ = new ArrayList();
    private IFile fileToExecute_;
    private int currentInputFileIndex_;
    private IFile currentInputFile_;
    public static final SimpleDateFormat FMT_DATETIME = new SimpleDateFormat("yyyyMMdd-HHmmss-SSS");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BlockDiagramExecutorManager getInstance(ExecutionEvent event) {
        IWorkbenchWindow win = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        ArrayList<BlockDiagramExecutorManager> arrayList = instances__;
        synchronized (arrayList) {
            BlockDiagramExecutorManager m2;
            for (BlockDiagramExecutorManager m2 : instances__) {
                if (m2.getWindow() != win) continue;
                return m2;
            }
            m2 = new BlockDiagramExecutorManager(win);
            instances__.add(0, m2);
            return m2;
        }
    }

    public IWorkbenchWindow getWindow() {
        return this.window_;
    }

    public BlockDiagramExecutorManager(IWorkbenchWindow window) {
        this.window_ = window;
    }

    public void executeFile(IFile fileToExecute) {
        this.stopExecution();
        LOG.debug((Object)("execute " + fileToExecute.getFullPath()));
        this.fileToExecute_ = fileToExecute;
        try {
            String contents = CoreUtil.readReaderAsString(new InputStreamReader(fileToExecute.getContents(), RuntimeContext.DEFAULT_CHARSET));
            this.iterateInputFiles_ = PAT_INPUT_FILE.matcher(contents).find();
            if (this.iterateInputFiles_) {
                IProject rootElemtnt = fileToExecute.getProject();
                if (this.intputFileDialog_ == null || this.inputFileDialogRootElement_ != rootElemtnt) {
                    this.inputFileDialogRootElement_ = rootElemtnt;
                    this.intputFileDialog_ = new ResourceSelectionDialog(this.window_.getShell(), this.inputFileDialogRootElement_, Messages.BlockDiagramExecutorManager_SelectInputFiles);
                }
                if (!this.inputFiles_.isEmpty()) {
                    this.intputFileDialog_.setInitialSelections(this.inputFiles_.toArray());
                }
                if (this.intputFileDialog_.open() != 0) {
                    return;
                }
                Object[] result = this.intputFileDialog_.getResult();
                this.inputFiles_.clear();
                Object[] objectArray = result;
                int n = result.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof IFile) {
                        IFile f = (IFile)obj;
                        String fp = f.getFullPath().toString();
                        if (fp.contains("/.svn") || fp.contains("/.git") || fp.contains("/.csv")) {
                            LOG.debug((Object)("skip:" + fp));
                        } else {
                            this.inputFiles_.add(f);
                        }
                    }
                    ++n2;
                }
                this.currentInputFileIndex_ = 0;
                if (this.inputFiles_.isEmpty()) {
                    UIUtil.showMessageDialog(this.window_.getShell(), Messages.BlockDiagramExecutorManager_NoValidInputFiles);
                    return;
                }
            }
            this.executeSub(contents);
        }
        catch (Exception ex) {
            CoreUtil.throwAsRuntimeException(ex);
        }
    }

    private void executeSub(final String contents) {
        IFile f = this.fileToExecute_;
        if (this.iterateInputFiles_) {
            this.currentInputFile_ = this.inputFiles_.get(this.currentInputFileIndex_);
            LOG.debug((Object)("input file: " + this.currentInputFile_.getFullPath()));
        }
        XStream xs = BlockDiagramExecutor.newXStream();
        BlockDiagram bd = (BlockDiagram)xs.fromXML(this.preprocess(contents));
        this.executor_ = new BlockDiagramExecutor();
        final RuntimeContext runtimeContext = this.executor_.getRuntimeContext();
        runtimeContext.putObjectToRepogitory(IWorkbenchWindow.class, (Object)this.getWindow());
        runtimeContext.putObjectToRepogitory("blockDiagramFileName", (Object)f.getName());
        runtimeContext.setFileStreamProvider(new ResourceStreamProvider(f.getParent(), runtimeContext));
        if (this.iterateInputFiles_) {
            runtimeContext.tasksTerminationListeners().add(new Runnable(){

                @Override
                public void run() {
                    runtimeContext.tasksTerminationListeners().remove(this);
                    BlockDiagramExecutorManager.this.executor_ = null;
                    BlockDiagramExecutorManager.this.window_.getShell().getDisplay().asyncExec(new Runnable(){

                        /*
                         * Enabled aggressive block sorting
                         */
                        @Override
                        public void run() {
                            if (BlockDiagramExecutorManager.this.iterateInputFiles_) {
                                BlockDiagramExecutorManager blockDiagramExecutorManager = BlockDiagramExecutorManager.this;
                                int n = blockDiagramExecutorManager.currentInputFileIndex_ + 1;
                                blockDiagramExecutorManager.currentInputFileIndex_ = n;
                                if (n < BlockDiagramExecutorManager.this.inputFiles_.size()) {
                                    BlockDiagramExecutorManager.this.executeSub(contents);
                                    return;
                                }
                            }
                            LOG.debug((Object)"done all input files.");
                        }
                    });
                }
            });
        }
        this.executor_.execute(bd);
    }

    private String preprocess(String contents) {
        return BlockDiagramExecutorManager.preprocess_currentDateTime(this.preprocess_inputFiles(contents));
    }

    public static String preprocess_currentDateTime(String contents) {
        Matcher m = PAT_CURRENT_DATETIME.matcher(contents);
        if (!m.find()) {
            return contents;
        }
        StringBuilder sb = new StringBuilder();
        int cursor = 0;
        do {
            sb.append(contents, cursor, m.start());
            cursor = m.end();
            sb.append(FMT_DATETIME.format(new Date()));
        } while (m.find(cursor));
        sb.append(contents, cursor, contents.length());
        return sb.toString();
    }

    private String preprocess_inputFiles(String contents) {
        if (!this.iterateInputFiles_) {
            return contents;
        }
        StringBuilder sb = new StringBuilder();
        Matcher m = PAT_INPUT_FILE.matcher(contents);
        int cursor = 0;
        while (m.find(cursor)) {
            sb.append(contents, cursor, m.start());
            cursor = m.end();
            String prop = m.group(1);
            if (prop.equals("path")) {
                sb.append(this.modifyPath(this.currentInputFile_.getFullPath().toString()));
                continue;
            }
            if (prop.equals("parentPath")) {
                sb.append(this.modifyPath(this.currentInputFile_.getParent().getFullPath().toString()));
                continue;
            }
            if (prop.equals("name")) {
                sb.append(this.currentInputFile_.getName());
                continue;
            }
            if (!prop.equals("nameWithoutExt")) continue;
            sb.append(this.removeFileExt(this.currentInputFile_.getName()));
        }
        sb.append(contents, cursor, contents.length());
        return sb.toString();
    }

    private String modifyPath(String path) {
        String prefix = this.fileToExecute_.getProject().getFullPath().toString();
        if (path.startsWith(prefix)) {
            path = "$(projectRoot)" + path.substring(prefix.length());
        }
        return path;
    }

    private String removeFileExt(String name) {
        int idx = name.lastIndexOf(".");
        return idx >= 0 ? name.substring(0, idx) : name;
    }

    public void stopExecution() {
        this.iterateInputFiles_ = false;
        if (this.executor_ != null) {
            this.executor_.getRuntimeContext().stopTasks();
        }
    }
}

