/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.ui.commands;

import jp.hasc.hasctool.ui.commands.BlockDiagramExecutorManager;
import jp.hasc.hasctool.ui.commands.Messages;
import jp.hasc.hasctool.ui.util.UIUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.part.FileEditorInput;

public class ExecuteBlockDiagramCommand
extends AbstractHandler {
    private static final Log LOG = LogFactory.getLog(ExecuteBlockDiagramCommand.class);
    public static final String ID_COMMAND = "jp.hasc.hasctool.ui.commands.ExecuteBlockDiagramCommand";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            ISelection selection;
            IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
            if (part instanceof IEditorPart) {
                FileEditorInput fei;
                IFile f;
                IEditorPart te = (IEditorPart)part;
                IEditorInput ei = te.getEditorInput();
                if (ei instanceof FileEditorInput && (f = (fei = (FileEditorInput)ei).getFile()).getName().endsWith(".hascxbd")) {
                    this.executeBlockDiagramFile(f, event);
                    return null;
                }
            } else if (part instanceof CommonNavigator && (selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event)) instanceof StructuredSelection) {
                StructuredSelection ss = (StructuredSelection)selection;
                for (Object item : ss) {
                    if (!(item instanceof IFile)) continue;
                    IFile f = (IFile)item;
                    this.executeBlockDiagramFile(f, event);
                    return null;
                }
            }
            UIUtil.showMessageDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), Messages.ExecuteBlockDiagramCommand_SelectHascXbdFile);
            return null;
        }
        catch (Exception ex) {
            LOG.warn((Object)"Exception", (Throwable)ex);
            UIUtil.showMessageDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), "[Exception]\n" + ex.toString());
            return null;
        }
    }

    private void executeBlockDiagramFile(IFile f, ExecutionEvent event) {
        BlockDiagramExecutorManager m = BlockDiagramExecutorManager.getInstance(event);
        m.executeFile(f);
    }
}

