/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.ui.commands;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.ui.commands.Messages;
import jp.hasc.hasctool.ui.util.UIUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class NewLabelFileFromCSVCommand
extends AbstractHandler {
    private static final Log LOG = LogFactory.getLog(NewLabelFileFromCSVCommand.class);
    public static final String ID = "jp.hasc.hasctool.ui.commands.NewLabelFileFromCSVCommand";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            if (selection instanceof StructuredSelection) {
                StructuredSelection ss = (StructuredSelection)selection;
                for (Object item : ss) {
                    if (!(item instanceof IFile)) continue;
                    IFile f = (IFile)item;
                    this.processFile(f, event);
                    return null;
                }
            }
            UIUtil.showMessageDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), Messages.NewLabelFileFromCSVCommand_SelectCSVFile);
            return null;
        }
        catch (Exception ex) {
            LOG.warn((Object)"Exception", (Throwable)ex);
            UIUtil.showMessageDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), "[Exception]\n" + ex.toString());
        }
        return null;
    }

    private void processFile(IFile f, ExecutionEvent event) throws CoreException {
        IWorkbenchWindow win = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        String fpath = f.getFullPath().toString();
        int idx = fpath.lastIndexOf(46);
        String lpath = String.valueOf(idx < 0 ? fpath : fpath.substring(0, idx)) + ".label";
        InputDialog dlg = new InputDialog(win.getShell(), Messages.NewLabelFileFromCSVCommand_NewLabelFile, Messages.NewLabelFileFromCSVCommand_InputLabelFilePath, lpath, null);
        if (dlg.open() != 0) {
            return;
        }
        lpath = dlg.getValue();
        IFile lf = f.getWorkspace().getRoot().getFile((IPath)new Path(lpath));
        if (lf.exists() && !MessageDialog.openConfirm((Shell)win.getShell(), (String)Messages.NewLabelFileFromCSVCommand_Overwrite, (String)(String.valueOf(Messages.NewLabelFileFromCSVCommand_OverwriteOK) + "\n" + lpath))) {
            return;
        }
        String ppath = lf.getProject().getFullPath().toString();
        if (fpath.startsWith(ppath)) {
            fpath = "$(projectRoot)" + fpath.substring(ppath.length());
        }
        String contents = "#targetfile:" + fpath + "\n";
        ByteArrayInputStream source = new ByteArrayInputStream(contents.getBytes(RuntimeContext.DEFAULT_CHARSET));
        if (lf.exists()) {
            lf.setContents((InputStream)source, true, false, null);
        } else {
            lf.create((InputStream)source, true, null);
        }
        UIUtil.showMessageDialog(win.getShell(), String.format(Messages.NewLabelFileFromCSVCommand_Created, lpath));
    }
}

