/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.ui.commands;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.List;
import jp.hasc.hasctool.core.runtime.AbstractTask;
import jp.hasc.hasctool.core.runtime.FileStreamProvider;
import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.util.CoreUtil;
import jp.hasc.hasctool.ui.commands.ProgressMonitorForBlocking;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class ResourceStreamProvider
implements FileStreamProvider {
    private static final Log LOG = LogFactory.getLog(ResourceStreamProvider.class);
    public static final String KEYWORD_PROJECT_ROOT = "$(projectRoot)";
    public static final String KEYWORD_WORKSPACE_ROOT = "$(workspaceRoot)";
    private final IContainer baseContainer_;
    private final RuntimeContext runtimeContext_;
    private boolean usingMemoryOutputStream_ = false;

    public ResourceStreamProvider(IContainer baseContainer, RuntimeContext runtimeContext) {
        this.baseContainer_ = baseContainer;
        this.runtimeContext_ = runtimeContext;
    }

    @Override
    public OutputStream openOutputStream(final String path) {
        if (path == null) {
            throw new NullPointerException("path is null");
        }
        if (this.usingMemoryOutputStream_) {
            ByteArrayOutputStream baout = new ByteArrayOutputStream(){

                @Override
                public void close() throws IOException {
                    super.close();
                    try {
                        ByteArrayInputStream bain = new ByteArrayInputStream(this.toByteArray());
                        IFile outf = ResourceStreamProvider.this.getFile(path);
                        ResourceStreamProvider.this.mkdirs(outf.getParent());
                        ProgressMonitorForBlocking blk = new ProgressMonitorForBlocking();
                        if (outf.exists()) {
                            outf.setContents((InputStream)bain, true, false, (IProgressMonitor)blk);
                        } else {
                            outf.create((InputStream)bain, true, (IProgressMonitor)blk);
                        }
                        blk.awaitDone();
                        bain.close();
                        LOG.info((Object)("wrote file: " + outf.getFullPath()));
                    }
                    catch (Exception ex) {
                        CoreUtil.throwAsRuntimeException(ex);
                    }
                }
            };
            return baout;
        }
        try {
            final PipedInputStream pis = new PipedInputStream();
            PipedOutputStream pos = new PipedOutputStream(pis);
            AbstractTask task = new AbstractTask(){

                @Override
                protected void run() throws InterruptedException {
                    try {
                        IFile outf = ResourceStreamProvider.this.getFile(path);
                        ResourceStreamProvider.this.mkdirs(outf.getParent());
                        ProgressMonitorForBlocking blk = new ProgressMonitorForBlocking();
                        if (outf.exists()) {
                            outf.setContents((InputStream)pis, true, false, (IProgressMonitor)blk);
                        } else {
                            outf.create((InputStream)pis, true, (IProgressMonitor)blk);
                        }
                        blk.awaitDone();
                        pis.close();
                        LOG.info((Object)("wrote file: " + outf.getFullPath()));
                    }
                    catch (Exception ex) {
                        CoreUtil.throwAsRuntimeException(ex);
                    }
                }
            };
            task.setup(this.runtimeContext_);
            task.start();
            return pos;
        }
        catch (IOException ex) {
            CoreUtil.throwAsRuntimeException(ex);
            return null;
        }
    }

    @Override
    public InputStream openInputStream(String path) {
        if (path == null) {
            throw new NullPointerException("path is null");
        }
        try {
            return this.getFile(path).getContents();
        }
        catch (CoreException ex) {
            CoreUtil.throwAsRuntimeException(ex);
            return null;
        }
    }

    public RuntimeContext getRuntimeContext() {
        return this.runtimeContext_;
    }

    public boolean isUsingMemoryOutputStream() {
        return this.usingMemoryOutputStream_;
    }

    public void setUsingMemoryOutputStream(boolean usingMemoryOutputStream) {
        this.usingMemoryOutputStream_ = usingMemoryOutputStream;
    }

    public IFile getFile(String path) throws CoreException {
        if (path.startsWith(KEYWORD_PROJECT_ROOT)) {
            return this.baseContainer_.getProject().getFile(path.substring(KEYWORD_PROJECT_ROOT.length()));
        }
        if (path.startsWith(KEYWORD_WORKSPACE_ROOT)) {
            return this.baseContainer_.getWorkspace().getRoot().getFile((IPath)new Path(path.substring(KEYWORD_WORKSPACE_ROOT.length())));
        }
        if (path.startsWith("/")) {
            return this.baseContainer_.getWorkspace().getRoot().getFile((IPath)new Path(path));
        }
        return this.baseContainer_.getFile((IPath)new Path(path));
    }

    public IFolder getFolder(String path) throws CoreException {
        if (path.startsWith(KEYWORD_PROJECT_ROOT)) {
            return this.baseContainer_.getProject().getFolder(path.substring(KEYWORD_PROJECT_ROOT.length()));
        }
        if (path.startsWith(KEYWORD_WORKSPACE_ROOT)) {
            return this.baseContainer_.getWorkspace().getRoot().getFolder((IPath)new Path(path.substring(KEYWORD_WORKSPACE_ROOT.length())));
        }
        if (path.startsWith("/")) {
            return this.baseContainer_.getWorkspace().getRoot().getFolder((IPath)new Path(path));
        }
        return this.baseContainer_.getFolder((IPath)new Path(path));
    }

    private void mkdirs(IContainer container) throws CoreException, InterruptedException {
        if (!container.exists() && container instanceof IFolder) {
            this.mkdirs(container.getParent());
            ProgressMonitorForBlocking blk = new ProgressMonitorForBlocking();
            IFolder folder = (IFolder)container;
            folder.create(true, true, (IProgressMonitor)blk);
            blk.awaitDone();
        }
    }

    @Override
    public void listFileNames(String folderPath, List<String> out) {
        try {
            IFolder folder = this.getFolder(folderPath);
            IResource[] iResourceArray = folder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                String cname;
                IResource r = iResourceArray[n2];
                if (r.getType() == 1 && !(cname = r.getName()).startsWith(".csv")) {
                    out.add(cname);
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            CoreUtil.throwAsRuntimeException(ex);
        }
    }

    @Override
    public void listSubFolderNames(String folderPath, List<String> out) {
        try {
            IFolder folder = this.getFolder(folderPath);
            IResource[] iResourceArray = folder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                String cname;
                IResource r = iResourceArray[n2];
                if (r.getType() == 2 && !(cname = r.getName()).equals(".svn") && !cname.equals(".git")) {
                    out.add(cname);
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            CoreUtil.throwAsRuntimeException(ex);
        }
    }
}

