/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.ui.views;

import jp.hasc.hasctool.ui.views.WaveViewWidget;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;

public abstract class AbstractWaveEditor
extends MultiPageEditorPart
implements IResourceChangeListener {
    private static final Log LOG = LogFactory.getLog(AbstractWaveEditor.class);
    public static final long DEFAULT_TASK_TIMEOUT = 30000L;
    protected TextEditor textEditor_;
    protected WaveViewWidget waveViewWidget_;
    protected int textEditorPageIndex_;
    protected int waveEditorPageIndex_;

    public AbstractWaveEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    protected void createTextEditorPage() {
        try {
            this.textEditor_ = new TextEditor();
            this.textEditorPageIndex_ = this.addPage((IEditorPart)this.textEditor_, this.getEditorInput());
            this.setPageText(this.textEditorPageIndex_, "Text");
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested text editor", null, (IStatus)e.getStatus());
        }
    }

    protected void createWaveEditorPage() {
        this.waveViewWidget_ = new WaveViewWidget(this.getContainer(), 0);
        this.waveViewWidget_.setFollowSlider(false);
        this.waveEditorPageIndex_ = this.addPage((Control)this.waveViewWidget_);
        this.setPageText(this.waveEditorPageIndex_, "Wave");
    }

    protected void createPages() {
        this.createTextEditorPage();
        this.createWaveEditorPage();
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        this.textEditor_.doSave(monitor);
    }

    public void doSaveAs() {
        TextEditor editor = this.textEditor_;
        editor.doSaveAs();
        this.setInput(editor.getEditorInput());
        this.setPartName(this.getEditorInput().getName());
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(this.textEditorPageIndex_);
        IDE.gotoMarker((IEditorPart)this.textEditor_, (IMarker)marker);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput");
        }
        super.init(site, editorInput);
        this.setPartName(editorInput.getName());
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        if (newPageIndex == this.waveEditorPageIndex_) {
            this.updateWaveEditorViewContents();
        }
    }

    private void updateWaveEditorViewContents() {
        String editorText = this.textEditor_.getDocumentProvider().getDocument((Object)this.textEditor_.getEditorInput()).get();
        try {
            this.onUpdateWaveEditorViewContents(editorText);
        }
        catch (Exception ex) {
            LOG.warn((Object)"Exception", (Throwable)ex);
        }
    }

    protected abstract void onUpdateWaveEditorViewContents(String var1) throws Exception;

    public void resourceChanged(final IResourceChangeEvent event) {
        if (event.getType() == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage[] pages = AbstractWaveEditor.this.getSite().getWorkbenchWindow().getPages();
                    int i = 0;
                    while (i < pages.length) {
                        if (((FileEditorInput)AbstractWaveEditor.this.textEditor_.getEditorInput()).getFile().getProject().equals((Object)event.getResource())) {
                            IEditorPart editorPart = pages[i].findEditor(AbstractWaveEditor.this.textEditor_.getEditorInput());
                            pages[i].closeEditor(editorPart, true);
                        }
                        ++i;
                    }
                }
            });
        }
    }

    public WaveViewWidget getWaveViewWidget() {
        return this.waveViewWidget_;
    }

    public TextEditor getTextEditor() {
        return this.textEditor_;
    }
}

