/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.ui.views;

import java.io.StringReader;
import java.util.ArrayList;
import jp.hasc.hasctool.core.messaging.MessageProcessor;
import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.filter.file.CSVToLabelFilter;
import jp.hasc.hasctool.core.runtime.filter.file.CSVToVectorFilter;
import jp.hasc.hasctool.core.runtime.filter.file.label.LabelFileParser;
import jp.hasc.hasctool.core.runtime.filter.file.label.LabelLine;
import jp.hasc.hasctool.core.runtime.filter.file.label.TargetFileReader;
import jp.hasc.hasctool.core.runtime.source.LineReaderSource;
import jp.hasc.hasctool.ui.commands.ResourceStreamProvider;
import jp.hasc.hasctool.ui.util.UIUtil;
import jp.hasc.hasctool.ui.views.AbstractWaveEditor;
import jp.hasc.hasctool.ui.views.CharPosLineReaderSource;
import jp.hasc.hasctool.ui.views.WaveViewWidget;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IFileEditorInput;

public class LabelEditor
extends AbstractWaveEditor {
    private static final Log LOG = LogFactory.getLog(LabelEditor.class);
    private static final long LONG_EPS = 1000L;

    @Override
    protected void onUpdateWaveEditorViewContents(String editorText) throws Exception {
        long pos = this.waveViewWidget_.getViewTimeMax();
        this.waveViewWidget_.preventUpdates(true);
        this.waveViewWidget_.clearData(3);
        int oldClearingDataWhenBeginMessage = this.waveViewWidget_.getClearingDataWhenBeginMessage();
        this.waveViewWidget_.setClearingDataWhenBeginMessage(0);
        RuntimeContext context = new RuntimeContext();
        context.setFileStreamProvider(new ResourceStreamProvider(((IFileEditorInput)this.getEditorInput()).getFile().getParent(), context));
        LineReaderSource lr = new LineReaderSource();
        lr.setReader(new StringReader(editorText));
        lr.setup(context);
        CSVToLabelFilter csvToLabel = new CSVToLabelFilter();
        csvToLabel.setup(context);
        TargetFileReader targetFileReader = new TargetFileReader();
        targetFileReader.setStartReader(false);
        targetFileReader.setup(context);
        CSVToVectorFilter csvToVector = new CSVToVectorFilter();
        csvToVector.setup(context);
        lr.getOutputPort().connect(csvToLabel.getInputPort());
        csvToLabel.getOutputPort().connect(this.waveViewWidget_.getInputPort());
        lr.getOutputPort().connect(targetFileReader.getInputPort());
        targetFileReader.getOutputPort().connect(csvToVector.getInputPort());
        csvToVector.getOutputPort().connect(this.waveViewWidget_.getInputPort());
        try {
            lr.runDirect();
            if (targetFileReader.getReader() != null) {
                targetFileReader.getReader().runDirect();
            }
        }
        catch (Throwable th) {
            UIUtil.showMessageDialog(this.getSite().getShell(), "[Error]\n" + th.toString());
            LOG.warn((Object)"Throwable", th);
        }
        this.waveViewWidget_.setClearingDataWhenBeginMessage(oldClearingDataWhenBeginMessage);
        this.waveViewWidget_.preventUpdates(false);
        this.waveViewWidget_.setViewTimeMax(pos);
    }

    @Override
    protected void createWaveEditorPage() {
        super.createWaveEditorPage();
        this.setPageText(this.waveEditorPageIndex_, "Wave&&Labels");
        final WaveViewWidget wv = this.getWaveViewWidget();
        ToolBar toolBar = wv.getToolBar();
        ToolItem ti = new ToolItem(toolBar, 0);
        ti.setText("?t");
        ti.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (wv.getTimeMarkerBegin() == null) {
                    UIUtil.showMessageDialog(LabelEditor.this.getSite().getShell(), "Please select a time or a time range.");
                    return;
                }
                long t0 = wv.getTimeMarkerBegin();
                long t1 = wv.getTimeMarkerEnd() == null ? t0 : wv.getTimeMarkerEnd();
                SourceViewer tv = (SourceViewer)LabelEditor.this.textEditor_.getAdapter(ITextOperationTarget.class);
                StyledText tw = tv.getTextWidget();
                try {
                    int[] pos = LabelEditor.this.searchCharPosesInTimeRange(tw, t0, t1);
                    tw.setSelection(pos[0], pos[1]);
                }
                catch (Throwable th) {
                    UIUtil.showMessageDialog(LabelEditor.this.getSite().getShell(), "[Error]\n" + th.toString());
                    LOG.warn((Object)"Throwable", th);
                }
                LabelEditor.this.setActivePage(LabelEditor.this.textEditorPageIndex_);
            }
        });
        ti = new ToolItem(toolBar, 0);
        ti.setText("+L");
        ti.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String lastS;
                if (wv.getTimeMarkerBegin() == null || wv.getTimeMarkerEnd() == null) {
                    UIUtil.showMessageDialog(LabelEditor.this.getSite().getShell(), "Please select a time range.");
                    return;
                }
                long t0 = wv.getTimeMarkerBegin();
                long t1 = wv.getTimeMarkerEnd();
                String text = String.valueOf(WaveViewWidget.timeToSecond(t0)) + "," + WaveViewWidget.timeToSecond(t1) + ",";
                SourceViewer tv = (SourceViewer)LabelEditor.this.textEditor_.getAdapter(ITextOperationTarget.class);
                StyledText tw = tv.getTextWidget();
                int insertPos = tw.getContent().getCharCount();
                try {
                    insertPos = LabelEditor.this.getInsertPos(tw, t0);
                }
                catch (Throwable th) {
                    LOG.warn((Object)"Throwable", th);
                }
                String lineDelimiter = tw.getContent().getLineDelimiter();
                tw.setSelection(insertPos);
                if (insertPos > 0 && !(lastS = tw.getText(insertPos - 1, insertPos - 1)).equals("\n") && !lastS.equals("\r")) {
                    tw.insert(lineDelimiter);
                    tw.setSelection(++insertPos);
                }
                tw.insert(String.valueOf(text) + lineDelimiter);
                tw.setSelection(insertPos + text.length());
                LabelEditor.this.setActivePage(LabelEditor.this.textEditorPageIndex_);
            }
        });
    }

    private int[] searchCharPosesInTimeRange(StyledText tw, long t0, long t1) throws InterruptedException {
        RuntimeContext context = new RuntimeContext();
        final CharPosLineReaderSource lr = new CharPosLineReaderSource();
        lr.setSourceText(tw.getText());
        lr.setup(context);
        LabelFileParser parser = new LabelFileParser();
        parser.setup(context);
        lr.getOutputPort().connect(parser.getInputPort());
        final ArrayList labels = new ArrayList();
        final ArrayList labelPoses = new ArrayList();
        parser.getOutputPort().connect(new MessageProcessor(){

            @Override
            public void processMessage(Object message) throws InterruptedException {
                if (message instanceof LabelLine) {
                    labels.add((LabelLine)message);
                    labelPoses.add(new int[]{lr.getPosCurrentLineBegins(), lr.getPosCurrentLineEnds()});
                }
            }
        });
        lr.runDirect();
        boolean found = false;
        boolean prevfound = false;
        boolean alert = false;
        int res0 = tw.getCharCount();
        int res1 = 0;
        int i = 0;
        while (i < labels.size()) {
            LabelLine label = (LabelLine)labels.get(i);
            int[] pos = (int[])labelPoses.get(i);
            if (t0 - 1000L <= label.timeBegin && label.timeEnd <= t1 + 1000L) {
                res0 = Math.min(res0, pos[0]);
                res1 = Math.max(res1, pos[1]);
                if (found && !prevfound) {
                    alert = true;
                }
                found = true;
                prevfound = true;
            } else {
                prevfound = false;
            }
            ++i;
        }
        if (alert) {
            UIUtil.showMessageDialog(this.getSite().getShell(), "[Warning]\nSome selected lines are out of the time range");
        }
        if (!found) {
            int cp = this.getInsertPos(tw, t0);
            return new int[]{cp, cp};
        }
        return new int[]{res0, res1};
    }

    public int getInsertPos(StyledText tw, final long t0) throws InterruptedException {
        final int[] res = new int[]{-1};
        RuntimeContext context = new RuntimeContext();
        final CharPosLineReaderSource lr = new CharPosLineReaderSource();
        lr.setSourceText(tw.getText());
        lr.setup(context);
        LabelFileParser parser = new LabelFileParser();
        parser.setup(context);
        lr.getOutputPort().connect(parser.getInputPort());
        parser.getOutputPort().connect(new MessageProcessor(){

            @Override
            public void processMessage(Object message) throws InterruptedException {
                if (message instanceof LabelLine) {
                    LabelLine line = (LabelLine)message;
                    if (line.timeBegin > t0 && res[0] < 0) {
                        res[0] = lr.getPosCurrentLineBegins();
                    }
                }
            }
        });
        lr.runDirect();
        if (res[0] < 0) {
            res[0] = tw.getContent().getCharCount();
        }
        return res[0];
    }
}

